﻿using System;

namespace Interface
{
    interface IVehicle
    {
        string Model
        {
            get;
        }

        int Speed
        {
            get;
        }
    }

    interface ITransportVehicle : IVehicle
    {

        int Weight
        {
            set;
            get;
        }
    }

class Car : IVehicle
    {
        public Car(string model, int speed)
        {
            Model = model;
            Speed = speed;
        }
        public string Model
        {
            get;
            private set;
        }

        public int Speed
        {
            get;
            private set;
        }
    }

    class Truck : ITransportVehicle, IVoiceMaker
    {
        public Truck(string model, int speed, int weight)
        {
            Model = model;
            Speed = speed;
            Weight = weight;
        }

        public string Model
        {
            get;
            private set;
        }

        public int Speed
        {
            get;
            private set;
        }

        public int Weight
        {
            get;
            set;
        }

        public string MakeVoice()
        {
            return "BRRRRRRR";
        }

    }

}