﻿using System;

namespace Interface
{
    abstract class Animal : IVoiceMaker
    {
        protected string _Name;

        public Animal(string name)
        {
            _Name = name;
        }

        public virtual string whoIsIt()
        {
            return "Animal: " + _Name;
        }

        public abstract string MakeVoice();
    }

    class Dog : Animal
    {
        public Dog(string name)
            : base(name)
        {

        }

        public override string whoIsIt()
        {
            return "Dog: " + _Name;
        }

        public override string MakeVoice()
        {
            return "Av av";
        }
    }

    class Cat : Animal
    {
        public Cat(string name)
            : base(name)
        {

        }

        public override string whoIsIt()
        {
            return "Cat: " + _Name;
        }

        public override string MakeVoice()
        {
            return "Mijau";
        }
    }

    class PitBull : Dog
    {
        public PitBull(string name)
            : base(name)
        {

        }

        public override string whoIsIt()
        {
            return "PitBull: " + _Name;
        }
    }
}
