﻿using System;

namespace Inheritance4
{
    abstract class Animal
    {
        public string Name
        {
            get;
            protected set;
        }

        public Animal(string name)
        {
            Name = name;
        }

        public abstract string whoIsIt();
    }

    class Dog : Animal
    {
        public Dog(string name)
            : base(name)
        {

        }

        public override string whoIsIt()
        {
            return "Dog: " + Name;
        }
    }

    class Cat : Animal
    {
        public Cat(string name)
            : base(name)
        {

        }

        public override string whoIsIt()
        {
            return "Cat: " + Name;
        }
    }

    class PitBull : Dog
    {
        public PitBull(string name)
            : base(name)
        {

        }

        public override string whoIsIt()
        {
            return "PitBull: " + Name;
        }
    }

}


