﻿using System;

namespace Inheritance3
{
    class Animal
    {
        public string Name
        {
            get;
            protected set;
        }

        public Animal(string name)
        {
            Name = name;
        }

        public virtual string ID
        {
            get
            {
                return "Animal: " + Name;
            }
        }

        public string whoIsIt()
        {
            return ID;
        }
    }

    class Dog : Animal
    {
        public Dog(string name)
            : base(name)
        {

        }

        public override string ID
        {
            get
            {
                return "Dog: " + Name;
            }
        }
    }

    class Cat : Animal
    {
        public Cat(string name)
            : base(name)
        {

        }

        public override string ID
        {
            get
            {
                return "Cat: " + Name;
            }
        }
    }

    class PitBull : Dog
    {
        public PitBull(string name)
            : base(name)
        {

        }

        public override string ID
        {
            get
            {
                return "PitBull: " + Name;
            }
        }
    }

}
