﻿using System;

namespace Inheritance2
{
    class Animal
    {
        public string Name
        {
            get;
            protected set;
        }

        public Animal(string name)
        {
            Name = name;
        }

        public virtual string whoIsIt()
        {
            return "Animal: " + Name;
        }
    }

    class Dog : Animal
    {
        public Dog(string name)
            : base(name)
        {

        }

        public override string whoIsIt()
        {
            return "Dog: " + Name;
        }
    }

    class Cat : Animal
    {
        public Cat(string name)
            : base(name)
        {

        }

        public override string whoIsIt()
        {
            return "Cat: " + Name;
        }
    }

    sealed class PitBull : Dog
    {
        public PitBull(string name)
            : base(name)
        {

        }

        public override sealed string whoIsIt()
        {
            return "PitBull: " + Name;
        }
    }

}
