﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HelloWorld
{
    class Program
    {
       /* 
        * Tipovi podataka:
        * 
        * sbyte, byte       1 bajt
        * short, ushort     2 bajta
        * int, uint         4 bajta
        * long, ulong       8 bajtova
        * float             4 bajta
        * double            8 bajtova
        * decimal           16 bajtova (dekadni eksponent)
        * bool              true, false
        * char              2 bajta, neoznacen (Unicode)
        * 
        * string            ugradjeni klasni tip
        * 
        * */
        static void Main(string[] args)
        {
            Console.WriteLine("Hello C# world");

            int x = 2, y = 5;
            System.Console.WriteLine("{0} + {1} = {2}", x, y, x + y);

            string s = "ovo je string";
            System.Console.WriteLine(s);

            /** Objekat klase string je nepromenljiv -- svaka promena
             *  zapravo kreira novi objekat klase string sa zeljenim
             *  izmenama. Originalni objekat ostaje nepromenjen. Rucka
             *  na stari objekat se, naravno, moze prebaciti na novi 
             *  objekat, u kom slucaju stari objekat ostaje u memoriji,
             *  i bice "ociscen" u nekom trenutku.
             */
            s.ToUpper();
            System.Console.WriteLine(s);

            s = s.ToUpper();
            System.Console.WriteLine(s);

            /* Dekadno zapisani brojevi imaju znatno vecu preciznost */
            decimal d = 0.5121434243245454213M;
            //double d = 0.5121434243245454213;
            System.Console.WriteLine(d);

            // Ako se inicijalizacija ne navede, onda je obavezna dimenzija,
            // a vrednosti su inicijalno 0 (kod vrednosnih tipova), odnosno null
            // (kod referencnih tipova).
            int[] a = new int[]{3,1,6,9,4};

            for (int i = 0; i < a.Length; i++)
                System.Console.Write(a[i] + " ");
            System.Console.WriteLine();

            System.Array.Sort(a);

            foreach (int e in a)
                System.Console.Write(e + " ");
            System.Console.WriteLine();
            
            string[] sarray = new string[3] { "abc", "def", "ghijk" };
            
            foreach (string str in sarray)
                System.Console.Write(str + " ");
            System.Console.WriteLine();

            // Moze i ovako
            //Array.ForEach(sarray, System.Console.WriteLine);


            // C# podrzava visedimenzione nizove, tj. "viseindeksne" nizove. Indeksi se
            // razdvajaju zarezima. Sve vrste moraju imati isti broj elemenata.
            int[,] twoDimArray = new int[2,4] { { 1, 2, 3, 4 }, { 5, 6, 7, 8 } };

            for (int i = 0; i < twoDimArray.GetLength(0); i++)
            {
                for (int j = 0; j < twoDimArray.GetLength(1); j++)
                    System.Console.Write(twoDimArray[i, j] + " ");
                System.Console.WriteLine("");
            }

            // Alternativno, C# podrzava i "nizove nizova" (jagged arrays), nalik onima u C-u, C++-u i Javi.
            int[][] jaggedArray = new int[][]{ new int[4] { 1, 2, 3, 4 }, new int[4] { 5, 6, 7, 8 } };

            for (int i = 0; i < jaggedArray.Length; i++)
            {
                for (int j = 0; j < jaggedArray[i].Length; j++)
                    System.Console.Write(jaggedArray[i][j] + " ");
                System.Console.WriteLine("");
            }
        }
    }
}
