﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Destruction
{
    class MyClass : IDisposable
    {
        /*
         * Metoda Dispose() se poziva ili rucno, ili automatski kada se izadje
         * iz using {} bloka. Koristi se za deterministicku dealokaciju resursa.
         * U ove resurse spadaju otvoreni fajlovi, konekcije sa bazom, i sl. 
         * U ove resurse ne spada memorija, jer je alokacija i dealokacija
         * memorije stvar skupljaca otpadaka.
         */
        public void Dispose()
        {
            System.Console.WriteLine("Disposing!");
            // Metoda SupressFinalize() se koristi da se spreci pozivanje finalizatora
            // prilikom destrukcije (od strane sakupljaca odpadaka). Ovo je korisno ako
            // se npr. u Dispose() metodi zatvara neki fajl, tada ne treba to ponovo 
            // raditi u finalizatoru (koji takodje zatvara fajl, za svaki slucaj, ako 
            // korisnik ne pozove Dispose()).
            //System.GC.SuppressFinalize(this);
        }

        // Finalizator se poziva nedeterminsiticki, u nekom trenutku od strane sakupljaca
        // odpadaka. U njemu se vrsi dealokacija resursa koje nije hitno osloboditi, niti
        // je bitno u kom se trenutku oslobadjaju. 
        ~MyClass()
        {
            System.Console.WriteLine("Finalizing!");
        }


    }
}
