/* Program kopira jedan tekstualni fajl u drugi, uz eventualne konverzije 
   malih slova u velika i/ili obrnuto, na osnovu opcija koje se, kao i
   imena fajlova, zadaju sa komandne linije. */

#include <stdio.h>
#include <ctype.h>

int main(int argc, char **argv)
{
  
  int c;
  int velika_u_mala = 0, mala_u_velika = 0;
  FILE *in = stdin, *out = stdout;

  /* NAPOMENA: Uobicajena praksa na UNIX sistemima je da se argumenti
     komandne linije  dele na opcije i argumente u uzem smislu
     (krace 'argumenti'). Opcije pocinju znakom '-' nakon cega obicno
     sledi jedan karakter koji oznacava koja je opcija u pitanju. Ovim
     se najcesce upravlja funkcionisanjem programa i neke mogucnosti
     se ukljucuju ili iskljucuju. Argumenti najcesce predstavljaju 
     opisne informacije poput imena fajla, ili podatke nekog drugog
     tipa. Ovaj primer demonstrira kako se tipicno ove opcije i 
     argumenti mogu ocitavati. */
  
  
  /* Ocitavamo opcije i argumente prilikom poziva programa */
  for(argv++, argc--; argc; argv++, argc--)
    {
      /* Ako je u pitanju opcija...*/
      if(**argv == '-')
	{
	  switch(*++*argv)
	    {
	    case 'l':
	      velika_u_mala = 1;
	      break;
	    case 'u':
	      mala_u_velika = 1;
	      break;
	    default:
	      printf("Pogresna opcija -%c\n", **argv);
	      return 1;
	      break;
	    }
	}
      /* Ako je u pitanju argument, prvi medju njima je ulazni fajl */
      else if(in == stdin)
	{
	  if((in = fopen(*argv, "r")) == NULL)
	    {
	      printf("Greska prilikom otvaranja fajla %s\n", *argv);
	      return 1;
	    }
	}
      /* Drugi argument (ako postoji) je izlazni fajl */
      else if(out == stdout)
	{
	  if((out = fopen(*argv, "w")) == NULL)
	    {
	      printf("Greska prilikom otvaranja fajla %s\n", *argv);
	      return 1;
	    }
	}
      /* Ignorisu se suvisni argumenti */
      else {
	printf("Suvisan argument %s -- ignorisan\n", *argv);
      }
      
    }
  

  /* Ako ne postoje argumenti na komandnoj liniji, tada pokazivaci
     in i out ostaju na svojim inicijalnim vrednostima, cime se 
     citanje vrsi sa standardnog ulaza, a rezultat se ispisuje na 
     standardni izlaz.
  */
  
  /* Prepisujemo ulaz na izlaz, uz eventualne konverzije */
  while((c = fgetc(in)) != EOF)
    {
      if(islower(c) && mala_u_velika)
	fputc(toupper(c), out);
      else if(isupper(c) && velika_u_mala)
	fputc(tolower(c), out);
      else
	fputc(c, out);
    }

  return 0;
}
