/* Program vrsi kopiranje jednog fajla u drugi. Imena ulaznog i izlaznog 
   fajla se zadaju na komandnoj liniji. */


#include <stdio.h>
#include <stdlib.h> 

int main(int argc, char ** argv)
{
  FILE *in, *out;
  int c;

  /* Proveravamo da li je korisnik uneo sve argumente komandne linije */
  if(argc < 3)
    {
      printf("Koriscenje programa: %s ulazni_fajl izlazni_fajl\n", argv[0]);
      return 1;
    }

  /* Otvaramo ulazni fajl za citanje */
  in = fopen(argv[1], "r");
  
  /* Ako je nastupila greska (fajl ne postoji ili nemamo
     pravo citanja) prekidamo program. */
  if(in == NULL)
    {
      printf("Greska prilikom otvaranja fajla\n");
      return 1;
    }

  /* Otvaramo izlazni fajl za pisanje */
  out = fopen(argv[2], "w");
  
  /* Ako je nastupila greska (nemamo pravo pisanja, ili
     ne mozemo da kreiramo fajl) prekidamo program */
  if(out == NULL)
    {
      printf("Greska prilikom otvaranja fajla\n");
      return 1;
    }


  /* Prepisujemo ulazni fajl u izlazni */
  while((c = fgetc(in)) != EOF)
    fputc(c, out);
  
  
  /* Zatvaramo fajlove */
  fclose(in);
  fclose(out);

  return 0;
}
