.intel_syntax noprefix

.data
rdfmt:	.asciz  "%d%x"		# Ulazni format.
wrfmt:	.asciz  "%x\n"		# Izlazni format.

.bss
.lcomm	n, 4			# Broj bitova koji se premecu.
.lcomm	x, 4			# Broj ciji se bitovi premecu.
		
.text
.global main

main:
	## Prolog funkcije.
	enter   0, 0
	pusha

	## Ucitavaju se broj bitova koji se premecu i broj ciji se
	## bitovi premecu.
	lea	eax, x
	push	eax
	lea	eax, n
	push	eax
	lea	eax, rdfmt
	push	eax
	call scanf
	add	esp, 12
	
	## U registar eax se prebacuje broj ciji se bitovi
	## premecu. Registar ecx ce biti koriscen kao brojac i u njega se
	## stavlja broj bitova koji se premecu. Pretpostavka je da je
	## ovaj broj u opsegu [0,32]. U registar ebx ce biti smjestani
	## premetnuti bitovi.
	mov	eax, x
	mov	ecx, n
	xor	ebx, ebx

	## Provjerava se da li je broj bitova koje treba premetnuti
	## jednak 0 i, ako jeste, odmah se ide na stampanje rezultata.
	jecxz print

again:
	## U petlji se izbacuje bit najmanje tezine iz registra eax i
	## odmah isti bit upisuje u bit najmanje tezine registra ebx.
	shr	eax, 1
	rcl	ebx, 1
	loop again

	## Vracaju se premetnuti bitovi u registar eax.
	mov	ecx, n
	shl	eax, cl
	or	eax, ebx
	
print:
	## Stampa se premetnuti broj.
	push	eax
	lea	eax, wrfmt
	push	eax
	call printf
	add	esp, 8
 	
	## Epilog funkcije.
	popa
	xor	eax, eax
	leave
	ret
