.intel_syntax noprefix

.text 

.global bit_count

##############################
## int bit_count(int x)  #####
##
## [ebp+8] -- int x     
##############################
bit_count:

## Prolog funkcije
enter 0,0


## Premestamo broj u ecx
mov ecx, [ebp+8]

## Postavljamo eax na 0. Ovaj registar ce nam
## biti brojac bitova postavljenih na 1 u broju
## x.
xor eax,eax

## U ovoj petlji testiramo bit po bit ulaznog
## podatka, i u slucaju pojave jedinice uvecavamo
## brojac eax za jedan.
next_bit:

## Uslov izlaska iz petlje: nema vise bitova koji
## su razliciti od nule!
jecxz last_bit

## Siftujemo edx u desno. Bit najmanje tezine odlazi
## u CF. Ako je CF nakon toga nula, prelazimo na 
## sledeci bit. Ako je CF jedan, onda najpre uvecavamo
## brojac.
shr ecx
jnc next_bit
inc eax
jmp next_bit

last_bit:

## Nakon zavrsetka petlje, u registru eax
## nam se nalazi izracunati broj bitova 
## koji su postavljeni na 1. To je upravo
## povratna vrednost.


## Epilog funkcije
leave
ret
