.intel_syntax noprefix

.data
ten: .int 10
	
.text
.global remove_vowels

##########################################################################
##
## Funkcija:
##
## void remove_vowels(char * s);
##
## eliminise samoglasnike iz stringa s. Argumenti funkcije su:
##
## -- char * s  -- [ebp+8]  -- adresa ulaznog stringa
##
###########################################################################
remove_vowels:
        ## Prolog funkcije.
        enter   0, 0
        push    esi
        push    edi

	## U registar esi smestamo adresu stringa. U registar edi
	## smestamo istu tu adresu, jer se rezultat smesta u isti
	## string.
	mov esi, [ebp + 8]
	mov edi, esi
	
	## Postavljamo smer kretanja kroz string
	cld
		
next_char:
	## Ucitavamo sledeci karakter
	lodsb

	## Da li smo dosli do kraja stringa?
	cmp al, 0
	je last_char
	
	## Proveravamo da li je tekuci karakter samoglasnik:
	cmp al, 'a'
	je equal
	cmp al, 'e'
	je equal
	cmp al, 'i'
	je equal
	cmp al, 'o'
	je equal
	cmp al, 'u'
	je equal
	cmp al, 'A'
	je equal
	cmp al, 'E'
	je equal
	cmp al, 'I'
	je equal
	cmp al, 'O'
	je equal
	cmp al, 'U'
	je equal

	## Ako nije samoglasnik, upisujemo ga.
	stosb

	## Ukoliko jeste samoglasnik, preskacemo ga i prelazimo na sledeci
	## karakter.
equal:
	## Prelazimo na sledeci karakter.
	jmp next_char
last_char:	

	## Upisujemo terminirajucu nulu u izlazni string.
	stosb	
done:	
	## Epilog funkcije
	pop edi
	pop esi
	leave
	ret
	