.intel_syntax noprefix

	
.text 
.global distance
#############################################################################
##
## Funkcija:
##
## void distance(float * x, float * y, int n, float a, float b, float * r);
##
## racuna sumu sum_{0..n-1}(a*x[i] + b - y[i])^2, koristeci paralelne SSE
## instrukcije. Argumenti funkcije su:
## 
## -- float * x --  [ebp+8]  -- adresa prvog niza
## -- float * y --  [ebp+12] -- adresa drugog niza
## -- int n     --  [ebp+16] -- duzina nizova
## -- float a   --  [ebp+20] -- koeficient a
## -- float b   --  [ebp+24] -- koeficient b
## -- float * r --  [ebp+28] -- adresa rezultata
############################################################################ 
distance:
	## Prolog funkcije
	enter 0,0
	push esi
	push edi
	
        ## Proverava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz not_supported

        ## Cuva se sadrzaj SSE registara (i registara koprocesora).
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

	## U registar ecx smestamo duzinu nizova n
	mov ecx, [ebp + 16]

	## U registar esi smestamo adresu prvog, a u edi drugog niza
	mov esi, [ebp + 8]
	mov edi, [ebp + 12]

	## U registru xmm2 cemo cuvati cetiri parcijalne sume
	xorps xmm2, xmm2

	## U registru xmm3 cuvamo (a, a, a, a)
	movss xmm3, [ebp + 20]
	shufps xmm3, xmm3, 0b00000000
	## U registru xmm4 cuvamo (b, b, b, b)
	movss xmm4, [ebp + 24]
	shufps xmm4, xmm4, 0b00000000
	
next_four:
	## Ako je ostalo bar jos cetiri sabirka
	cmp ecx, 4
	jb next_one

	## Ucitavamo sledeca cetiri para brojeva
	movups xmm0, [esi]
	add esi, 16
	movups xmm1, [edi]
	add edi, 16

	## Racunamo izraz a*x_i + b - y_i
	mulps xmm0, xmm3
	addps xmm0, xmm4
	subps xmm0, xmm1

	## Kvadriramo, i dodajemo na parcijalne sume
	mulps xmm0, xmm0
	addps xmm2, xmm0

	## Umanjujemo brojac i prelazimo na sledecu iteraciju
	sub ecx, 4
	jmp next_four

next_one:
	## Ako nema vise elemenata...
	jecxz last

	## Ucitavamo sledeci par brojeva
	movss xmm0, [esi]
	add esi, 4
	movss xmm1, [edi]
	add edi, 4

	## Racunamo izraz a*x_i + b - y_i
	mulss xmm0, xmm3
	addss xmm0, xmm4
	subss xmm0, xmm1

	## Kvadriramo, i dodajemo na najnizu parcijalnu sumu.
	mulss xmm0, xmm0
	addss xmm2, xmm0
	
	dec ecx
	jmp next_one
	
last:
	
	## Sabiramo dve parcijalne sume
	movhlps xmm0, xmm2
	addps xmm2, xmm0
	movaps xmm0, xmm2
	shufps xmm0, xmm0, 0b01010101
	addss xmm2, xmm0
	
	## Upisujemo rezultat u za to predvidjenu lokaciju
	mov esi, [ebp + 28]
	movss [esi], xmm2
	
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
	## registre.
        fxrstor [esp]
        mov     esp, edx

	## Epilog funkcije.
	pop edi
	pop esi
	leave
	ret

not_supported:
	## Ako SSE instrukcije nisu podrzane, prekidamo program exit(1)
	## pozivom. 
	mov eax, 1
	mov ebx, 1
	int 0x80
	