.text
.align 2


.global palindrom

@ Funkcija:
@
@ int palindrom(char * s);
@
@ Ispituje da li je dati string palindrom. Argument 
@ funkcije je:
@
@ -- r0 -- char * s -- adresa pocetka stringa
@
@ Funkcija vraca 1 ako jeste palindrom, 0 u suprotnom.
@
palindrom:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Adresu pocetka stringa kopiramo u r1. Ovaj registar cemo u 
	@ narednoj petlji postaviti da pokazuje na poslednji karakter
	@ u stringu.
	mov r1, r0

	@ Petlja pomera r1 na poslednji karakter u stringu.
next_char:
	@ Ucitavamo karakter i proveravamo da li je terminirajuca nula.
	ldrb r2, [r1]
	cmp r2, #0
	beq last_char

	@ Pomeramo pokazivac u desno i prelazimo na sledecu iteraciju.
	add r1, r1, #1
	b next_char
last_char:

	@ Vracamo pokazivac r1 za jedno mesto (jer se zaustavio na 
	@ terminirajucoj nuli).
	sub r1, r1, #1

	@ U petlji proveravamo jednakost odgovarajucih parova karaktera.
	@ r0 je pokazivac na levi karakter (inicijalno pocetni) a r2 je
	@ pokazivac na desni karakter u paru (inicijalno krajnji 
	@ karakter).
next_pair:
	@ Dokle god je r0 < r1
	cmp r0, r1
	bge last_pair
	
	@ Ucitavamo karakter na poziciji r0 u r2 a karakter na poziciji
	@ r1 u r3, nakon cega uvecavamo r0 i umanjujemo r1.
	ldrb r2, [r0], #1
	ldrb r3, [r1], #-1

	@ Uporedjujemo ucitane karaktere. Ako nisu jednaki, string nije 
	@ palindrom.
	cmp r2, r3
	bne fail

	b next_pair
last_pair:

	@ U slucaju uspeha, vracamo 1.
	mov r0, #1
	b done

fail:
	@ U slucaju neuspeha, vracamo 0.
	mov r0, #0

done:
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
