.text
.align 2


.global norms

@ Funkcija:
@
@ void norms(int ** a, int m, int n, int * h, int * v);
@
@ Izracunava maksimum zbira apsolutnih vrednosti po vrstama, kao i 
@ maksimum zbira apsolutnih vrednosti po kolonama. Argumenti funkcije
@ su:
@
@ r0 -- int ** a -- adresa pocetka niza pokazivaca na vrste
@ r1 -- int m -- broj vrsta
@ r2 -- int n -- broj kolona
@ r3 -- int * h -- adresa lokacije na koju treba upisati maksimum po 
@                  vrstama.
@ [fp + 8] -- int * v -- adresa lokacije na koju treba upisati maksimum
@                        po kolonama.
@
norms:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Alociramo lokalni niz celih brojeva duzine n. Ovaj niz ce se 
	@ koristiti za sume apsolutnih vrednosti elemenata po vrstama.
	sub sp, sp, r2, lsl #2 

	@ Cuvamo vrednosti registara koje cemo koristiti.
	stmfd sp!, {r4-r10}

	@ Registar r10 ce biti adresa niza suma po kolonama. 
	sub r10, fp, r2, lsl #2


	@ Naredna petlja inicijalizuje elemente lokalnog niza.

	@ Registar r4 ce nam biti brojac u petlji.
	mov r4, #0

	@ Registar r5 ce sardzati nulu.
	mov r5, #0

init_next:
	@ dok je brojac manji od n...
	cmp r4, r2
	beq init_last

	@ Upisujemo nulu u tekuci element niza.
	str r5, [r10, r4, lsl #2]

	@ Uvecavamo brojac i prelazimo na sledeci element.
	add r4, r4, #1
	b init_next
init_last:

		
	@ Naredna petlja iterira po vrstama matrice i racuna maksimum
	@ suma po vrstama.

	@ Registar r4 ce biti brojac spoljasnje petlje (indeks vrste)
	mov r4, #0

	@ Registar r5 ce biti maksimum sume po vrstama.
	mov r5, #0
		
next_row:
	@ Dok je brojac manji od m
	cmp r4, r1
	beq last_row

	@ Unutrasnja petlja iterira kroz tekucu vrstu i racuna sumu
	@ apsolutnih vrednosti njenih elemenata. Elementi se usput
	@ dodaju i na sume po kolonama (koje se nalaze u elementima
	@ lokalnog niza).

	@ Registar r6 ce biti suma tekuce vrste
	mov r6, #0
	
	@ Registar r7 ce biti brojac unutrasnje petlje (indeks kolone)
	mov r7, #0

	@ Registar r8 ce biti adresa tekuce vrste.
	ldr r8, [r0, r4, lsl #2]	

next_element:
	@ Dok je brojac manji od n
	cmp r7, r2
	beq last_element

	@ Ucitavamo tekuci element vrste i racunamo njegovu apsolutnu 
	@ vrednost.
	ldr r9, [r8, r7, lsl #2]
	cmp r9, #0
	rsblt r9, r9, #0

	@ Dodajemo ga na sumu vrste.
	add r6, r6, r9

	@ Ucitavamo tekucu vrednost sume kolone kojoj pripada tekuci 
	@ element i uvecavamo je za vrednost elementa, a zatim je 
	@ ponovo upisujemo u memoriju.
	ldr ip, [r10, r7, lsl #2]
	add ip, ip, r9
	str ip, [r10, r7, lsl #2]	
	
	@ Uvecavamo brojac i prelazimo na sledeci element.
	add r7, r7, #1
	b next_element
last_element:
	
	@ Ako je suma po vrsti veca od do sada najvece, azuriramo 
	@ najvecu sumu.
	cmp r6, r5
	movgt r5, r6
	
	@ Uvecavamo brojac i prelazimo na sledecu vrstu.
	add r4, r4, #1
	b next_row
last_row:

	@ Naredna petlja odredjuje maksimalnu sumu po kolonama, kao 
	@ maksimum lokalnog niza u kome se te sume nalaze. 
	
	@ Registar r4 ce nam biti brojac u petlji.
	mov r4, #0
	@ Registar r6 ce sardzati tekuci maksimum.
	mov r6, #0

check_next:
	@ Dok je brojac manji od n
	cmp r4, r2
	beq check_last

	@ Ucitavamo tekuci element niza i ako je veci od tekuceg 
	@ maskimuma, azuriramo maksimum.
	ldr r7, [r10, r4, lsl #2]
	cmp r7, r6
	movgt r6, r7

	@ Uvecavamo brojac i prelazimo na sledecu iteraciju.
	add r4, r4, #1
	b check_next
check_last:
	
	@ Cuvamo vrednosti na za to predvidjene lokacije.
	str r5, [r3]
	ldr r3, [fp, #8]
	str r6, [r3]

	@ Vracamo sa steka vrednosti registara koje smo koristili. 
	ldmfd sp!, {r4-r10}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
