.text
.align 2



.global mirror

@ Funkcija
@
@	unsigned mirror(unsigned x);
@
@ vraca broj ciji je binarni zapis jednak binarnom zapisu broja x u
@ ogledalu. Argument funkcije je:
@
@  -- r0 -- unsigned x -- dati broj.
@
mirror:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ U registar r3 smestamo 32. Ovaj registar koristimo kao brojac
	@ iteracija.
	mov r3, #32
	
	@ U registar r1 smestamo 0. U ovom registru cemo formirati 
	@ rezultat.
	mov r1, #0

next_bit0:
	@ Dok je brojac veci od nule...
	cmp r3, #0
	beq last_bit0

	@ Pomeramo rezultat u levo za jedno mesto.
	mov r1, r1, lsl #1

	@ Ispitujemo bit najmanje tezine u broju r0.
	tst r0, #1

	@ Ako je bit jedinica, tada ukljucujemo bit najmanje tezine u 
	@ rezultatu.
	orrne r1, r1, #1

	@ Pomeramo broj u r0 u desno za jednu poziciju.
	mov r0, r0, lsr #1

	@ Umanjujemo brojac i prelazimo na sledecu iteraciju.
	sub r3, r3, #1
	b next_bit0	
last_bit0:

	@ Smestamo rezultat u r0.
	mov r0, r1

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}



.global printbits

@ Funkcija:
@
@ 	void printbits(unsigned x);
@
@ prikazuje binarni zapis broja x na standardnom izlazu. Argument
@ funkcije je:
@
@ -- r0 -- unsigned x -- dati broj
@ 	
printbits:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo registre koje cemo koristiti.
	stmfd sp!, {r4, r5}

	@ U registar r4 smestamo x.
	mov r4, r0

	@ U registar r5 smestamo masku cija je vrednost inicijalno
	@ 1000...0000
	mov r5, #1
	mov r5, r5, lsl #31
	
next_bit:
	@ Dok maska ne postane nula
	cmp r5, #0
	beq last_bit

	@ Testiramo bit
	tst r4, r5
	beq zero
	
	@ Ako je jedan, pozivamo putchar('1');
	mov r0, #'1'
	bl putchar
	b continue	
zero:

	@ Ako je nula, pozivamo putchar('0');
	mov r0, #'0'
	bl putchar
	
continue:
	@ Pomeramo masku za jednu poziciju u desno.
	mov r5, r5, lsr #1
	b next_bit
last_bit:

	@ Pozivamo putchar('\n');
	mov r0, #'\n'
	bl putchar

	@ Vracamo vrednosti registara koje smo koristili.
	ldmfd sp!, {r4, r5}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
