.text
.align 2


.global longest

@ Funkcija:
@
@ void longest(char * str, int * start, int * length);
@
@ pronalazi najduzu sekvencu istih karaktera u stringu. Argumenti 
@ funkcije su:
@
@ -- r0 -- char * str -- adresa pocetka stringa
@ -- r1 -- int * start -- lokacija na koju treba upisati indeks pocetka
@          sekvence.
@ -- r2 -- int * length -- lokacija na koju treba upisati duzinu 
@          sekvence.
@
longest:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Postavljamo na stek  vrednosti registara koje cemo koristiti.
	stmfd sp!, {r4-r8}

	@ Registar r4 cuva pocetni indeks do sada najduze sekvence. 
	@ Registar r5 cuva duzinu do sada najduze sekvence.
	mov r4, #0
	mov r5, #0

	@ Ucitavamo prvi karakter i proveravamo da li je nula. 
	ldrb r3, [r0], #1
	cmp r3, #0
	beq store


	@ Registar r6 cuva indeks pocetka tekuce sekvence.
	@ Registar r7 cuva tekucu duzinu sekvence.
	@ Registar r8 cuva prethodni karakter.
	mov r6, #0
	mov r7, #1
	mov r8, r3

next_char:
	@ Ucitavamo sledeci karakter i proveravamo da li je nula.
	ldrb r3, [r0], #1
	cmp r3, #0
	beq last_char	

	@ Uporedjujemo tekuci karakter sa prethodnim.
	cmp r8, r3
	beq equal
	
	@ Ako su razliciti, to je kraj tekuce sekvence. U tom slucaju
	@ poredimo duzinu tekuce sekvence sa do sada najduzom. 
	cmp r7, r5
	ble skip

	@ Ako je tekuca sekvenca duza, tada se azuriraju informacije
	@ o najduzoj sekvenci.
	mov r4, r6
	mov r5, r7

skip:
	@ Inicijalizujemo sledecu sekvencu.
	add r6, r6, r7
	mov r7, #1

	b continue

equal:
	@ Ako su tekuci i prethodni karakter jednaki, uvecavamo duzinu 
	@ tekuce sekvence.
	add r7, r7, #1
continue:
	@ Tekuci postaje prethodni i prelazimo na sledeci karakter.
	mov r8, r3
	b next_char
last_char:

	@ Proveravamo da li je mozda poslednja sekvenca najduza.
	cmp r7, r5
	ble store
	mov r4, r6
	mov r5, r7

store:
	@ Cuvamo vrednosti u za to predvidjene lokacije.
	str r4, [r1]
	str r5, [r2]

	@ Vracamo vrednosti registara koji su korisceni.
	ldmfd sp!, {r4-r8}

done:
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
