#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STR_LEN 100

/* Funkcija poredi pokazivace na karaktere. Relacija
   poretka definisana je na sledeci nacin:
        p1 < p2 <==> string na koji pokazuje p1 je 
         leksikografski manji od stringa na koji 
         pokazuje p2.
*/
int char_p_compare (const void *p1, const void *p2)
{
  /* Konvertujemo genericke pokazivace u pokazivace
     na pokazivace na karaktere, koje zatim derefe-
     renciramo dobivsi pritom pokazivace na karaktere.
     Ovi se pokazivaci predaju funkciji strcmp() koja
     uporedjuje stringove na koje ovi pokazivaci 
     pokazuju */
  return strcmp (*(char **) p1, *(char **) p2);
}

/* glavni program */
int
main (int argc, char **argv)
{

  int n, i;
  char str[MAX_STR_LEN];
  char **str_p;


/* unosimo broj elemenata */
  printf ("Unesite broj stringova: ");
  scanf ("%d", &n);

  /* Dinamicki alociramo prostor za n pokazivaca na karaktere */
  if((str_p = malloc(n * sizeof(char *))) == NULL)
  {
    fprintf(stderr, "malloc() greska!\n");
    exit(1);
  } 

/* unosimo redom stringove i inicijalizujemo pokazivace. Za unos
   stringa koristimo pomocni niz str[] staticke duzine MAX_STR_LEN.
   Nakon unosenja odredimo duzinu unetog stringa, a zatim dinamicki
   alociramo niz karaktera potrebne duzine (strlen(str) + 1). Nakon
   alokacije kopiramo string u novoalocirani niz, cija se adresa
   smesta u str_p[i]. Ovim se racionalnije koristi prostor, imajuci
   u vidu nejednaku duzinu stringova. */
  for (i = 0; i < n; i++)
    {
      scanf ("%99s", str);
      str_p[i] = malloc(sizeof(char) * (strlen(str) + 1));
      if(str_p[i] == NULL)
      {
         fprintf(stderr, "malloc() greska!\n");
         exit(1);
      } 
     strcpy(str_p[i], str);
    }

/* sortiramo niz stringova. Tacnije, sortiramo niz
   pokazivaca na stringove, tako da stringovi na
   koje oni redom pokazuju budu u rastucem poretku. 
   Poredjenje pokazivaca vrsi se funkcijom 
   char_p_compare(), dok se prilikom premestanja 
   elemenata premestaju pokazivaci, a ne nizovi 
   karaktera, cime se citav proces sortiranja cini
   efikasnijim.
*/
  qsort (str_p, n, sizeof (char *), &char_p_compare);



/* S obzirom da je niz sortiran, ako postoje
   dva identicna stringa, oni moraju biti 
   susedni. Zato je dovoljno kretati se kroz
   niz stringova i porediti susedna dva elementa.
   Ako pronadjemo dva susedna identicna stringa
   izlazimo iz petlje. 
*/
  for (i = 1; i < n; i++)
    if (strcmp (str_p[i - 1], str_p[i]) == 0)
      break;			/* napustamo petlju */

/* ako je i<n, tada smo izasli ranije iz petlje,
   tj. pronasli smo identicne susede. */
  if (i < n)
    printf ("Postoje identicni stringovi: %s\n", str_p[i]);
  else
    printf ("Ne postoje identicni stringovi\n");

/* Dealokacija */
for(i = 0; i < n; i++)
 free(str_p[i]);
free(str_p);

  return 0;
}
