#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX 1000

/* NAPOMENA:
   Primer demonstrira "vracanje nizova iz funkcije". Znamo da u C-u
   tako nesto nije moguce. Medjutim, ovako nesto bi se moglo  
   improvizovati tako sto funkcija iznutra dinamicki kreira niz
   potrebne velicine, napuni ga povratnim informacijama, a zatim
   vrati njegovu adresu. Imajuci u vidu da dinamicki kreiran 
   objekat ne nestaje kada se izadje iz funkcije koja ga je 
   kreirala, vraceni pokazivac se kasnije u pozivajucoj funkciji
   moze koristiti za pristup "vracenom" nizu. Medjutim, pozivajuca
   funkcija ima odgovornost i da se brine o dealokaciji istog prostora */

/* Funkcija dinamicki kreira niz karaktera u koji smesta rezultat
   nadovezivanja stringova s i t. Adresa niza se vraca kao povratna
   vrednost. */
char * nadovezi_stringove(char *s, char *t)
{
   /* Dinamicki kreiramo prostor dovoljne velicine */
   char *p = malloc((strlen(s) + strlen(t) + 1) * sizeof(char));

   /* Proveravamo uspeh alokacije */
   if(p == NULL)
    {
     fprintf(stderr, "malloc() greska!\n");
     exit(1);
    }

   /* Kopiramo i nadovezujemo stringove */
   strcpy(p,s);
   strcat(p,t);

   /* Vracamo p */
   return p;
}

int main()
{
  char * p = NULL;
  char s[MAX], t[MAX];

  /* Ucitavamo stringove */
  scanf("%s", s);
  scanf("%s", t);
  
  /* Nadovezujemo stringove */
  p = nadovezi_stringove(s,t);
  
  /* Prikazujemo rezultat */
  printf("%s\n", p);

  /* Oslobadjamo memoriju*/
  free(p);
  
  return 0;
}
