#include <stdio.h>
#include <stdlib.h>


/* NAPOMENA: Do sada smo memoriju za podatke rezervisali
   na dva nacina:

   1) Staticka alokacija - podaci se kreiraju staticki
      prilikom pokretanja programa i ostaju u memoriji
      do kraja njegovog izvrsavanja. Ovakvu alokaciju
      imaju globalne promenljive (promenljive definisane
      van svake funkcije ili bloka) kao i staticke lokalne
      promenljive (deklarisane kljucnom recju static unutar
      funkcije ili bloka).
   2) Automatska alokacija - podaci se kreiraju automatski
      prilikom ulaska u funkciju ili blok, i nestaju kada
      se iz funkcije/bloka izadje. Ovakvo ponasanje imaju
      sve lokalne promenljive koje nisu deklarisane kao
      static. Prostor za ove promenljive se rezervise na
      sistemskom steku. 
   Glavni nedostatak oba ova pristupa je to sto programer
   u vreme pisanja programa mora da predvidi koliko ce mu
   prostora biti potrebno za podatke. Cesto tako nesto nije
   moguce, jer dimenzije problema mogu varirati. Drugi
   nedostatak je to sto je zivotni vek svakog podatka 
   jasno definisan gornjim pravilima. Programer moze zeleti
   da nakon kreiranja nekog objekta u memoriji on ostane
   tu dokle god nam je potreban, te da ga kasnije uklonimo
   kada mi zelimo.

   Svi ovi problemi resavaju se tzv. dinamickom alokacijom
   memorije. Pored staticke zone i steka, u memoriji postoji
   i odredjeni prostor koji se naziva hip (eng. heap). U ovom
   prostoru se po potrebi mogu kreirati objekti proizvoljne 
   velicine, onda kada programer to zazeli. Taj prostor se
   kasnije moze (i treba) osloboditi, opet kada programer vise
   nema potrebu da koristi taj objekat. 

   U programskom jeziku C, ovo se ostvaruje putem funkcije 
   standardne biblioteke malloc() koja je deklarisana u zaglavlju
   stdlib.h:

   void * malloc(int n);

   Ova funkcija alocira na hipu kontinualni prostor od n bajtova,
   i vraca adresu pocetka tog prostora. U ovaj prostor se sada 
   moze smestati sve sto u njega moze da stane. Jedini nacin da
   se ovom prostoru pristupi je preko pokazivaca (jer ne postoji
   ime promenljive kao kod statickih i automatskih promenljivih).
   
   Osim funkcije malloc() postoje jos dve funkcije za alokaciju:

   void * calloc(int n, int s);

   Ova funkcija alocira prostor za n susednih elemenata velicine 
   s bajtova (zapravo alocira n*s bajtova). Ova funkcija jos i
   inicijalizuje rezervisani prostor na vrednost 0, za razliku
   od malloc() funkcije koja prostor ostavlja neinicijalizovan.
   
   void * realloc(void *p, int n);

   Ova funkcija vrsi realokaciju prostora na koji pokazuje pokazivac
   p a koji je prethodno bio dinamicki alociran. Alocira se n bajtova,
   kopira se stari sadrzaj u novi prostor, a zatim se stari prostor
   brise. Ova funkcija se obicno koristi da bi se prosirio postojeci
   dinamicki alocirani prostor.

   Prostor alociran prethodnim funkcijama se moze dealocirati pozivom 
   funkcije:

   void free(void *p);

   koja je takodje deklarisana u zaglavlju stdlib.h, i koja za 
   argument mora imati adresu koju je funkcija (m|c|re)alloc() vratila
   u nekom od prethodnih poziva (drugim recima, ne moze se 
   proizvoljan prostor oslobadjati ovom funkcijom, vec samo prostor
   ne hipu alociran (m|c|re)alloc()-om). Kada se jednom dealocira, prostor
   vise ne sme da se koristi (vrlo je verovatno da ce ga kasnije 
   malloc() dodeliti necemu drugom).

   Trenutak oslobadjanja prostora na hipu odredjuje programer. Nebitno
   je da li smo izasli iz funkcije ili bloka u kome je malloc() funkcija
   pozvana, prostor ostaje rezervisan dokle god ne pozovemo free() nad
   adresom tog prostora koju je malloc() vratila. Ova memorija se moze
   koristiti i u drugim funkcijama sve dok imamo pokazivac kojim mozemo
   da joj pristupimo.

   Tiha greska je ako "izgubimo" pokazivac na dinamicki alocirani prostor,
   a da ga nismo prethodno dealocirali. U ovom slucaju taj prostor ostaje
   rezervisan do kraja izvrsavanja programa, bez mogucnosti da ga koristimo
   ili da ga kasnije obrisemo (jer nemamo njegovu adresu). Ovaj fenomen se 
   obicno naziva "curenje memorije" (eng. memory leak). Odgovornost je 
   programera kao i odlika dobrog stila da se dinamicki prostor uvek oslobodi
   kada vise nije potreban.
*/

int main()
{

  int *p;

  /* ALociramo prostor velicine jednog int podatka */
  p = malloc(sizeof(int));

  /* Nakon poziva malloc() funkcije obavezno proveriti
     da li je vracena vrednost NULL -- ovo je indikator
     neuspesne alokacije */
  if(p == NULL)
  {
      fprintf(stderr, "malloc() greska!\n");
      exit(1);
  }

   /* Ucitavamo int u dinamicki alocirani prostor */
   scanf("%d", p);

   /* Prikazujemo int */
   printf("%d\n", *p);

   /* Oslobadjamo dinamicki alocirani prostor */
   free(p);

  return 0;
}
