#include <stdio.h>
#include <math.h>

/* NAPOMENA:
   Struktura je slozeni tip podataka koji nastaje komponovanjem vise podataka
   koji mogu biti razlicitih tipova. Svaki podatak koji cini strukturu naziva
   se CLAN STRUKTURE. Njemu se pristupa preko identifikatora (ime clana).
   Definicijom strukture definise se TIP podataka. Promenljive ovog tipa se 
   mogu definisati kasnije u programu na bilo kom mestu. Za svaku promenljivu
   alocira se dovoljno prostora za cuvanje svih podataka koji su clanovi 
   strukture. Clanovima strukture pristupa se operatorom "tacka" 
   (npr a.x). Ovaj operator ima najvisi moguci prioritet. Jedine operacije
   koje su dozvoljene nad objektom strukturnog tipa su:
   - dodela vrednosti strukturnog tipa promenljivoj tog tipa.
   - uzimanje adrese operatorom & (cime se dobija pokazivac na strukturu)
   - pristup clanovima strukture, operatorom tacka.
   
   Kada je u pitanju odnos struktura i funkcija, vaze sledeca pravila:
   - struktura se moze prenositi kao argument funkcije. Pri tom se prenos
   vrsi po vrednosti (kreira se lokalna kopija)
   - struktura se moze vracati kao povratna vrednost funkcije.
   
   Sledi primer koji demonstrira upotrebu struktura.
*/


/* Definicija strukture. Ovim se definise novi tip podataka. Svugde gde nam
   je potreban taj tip, mozemo navesti 'struct tacka'. Podatke ovog tipa 
   mozemo definisati bilo gde kasnije u programu, a mogu se definisati i odmah
   na kraju definicije strukture, izmedju znaka } i znaka ;
*/
struct tacka
{
  double x;
  double y;
};

/* Funkcija racuna rastojanje izmedju tacaka a i b. Ova funkcija demonstrira 
   prenos podataka strukturnog tipa kao argumenata funkcije. Prenos
   se vrsi po vrednosti, tj. strukturni objekti se kopiraju u lokalne
   parametre strukturnog tipa. Ovo je veoma neefikasno, kod vecih struktura. */
double rastojanje (struct tacka a, struct tacka b)
{
  /* Obratiti paznju na upotrebu operatora tacka za pristup clanovima
     strukture. Ovaj operator ima najvisi moguci prioritet (kao
     postfiksni operator) */
  return sqrt ((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}


/* Funkcija racuna srediste duzi ab. Funkcija demonstrira vracanje objekta 
   strukturnog tipa iz funkcije. Ovo je dozvoljeno u C-u, ali takodje nije
   preterano efikasno, kada su u pitanju vece strukture (povratna vrednost 
   se kopira pozivajucoj funkciji, sto zahteva neko vreme) */
struct tacka srediste (struct tacka a, struct tacka b)
{
  struct tacka s;

  s.x = (a.x + b.x) / 2;
  s.y = (a.y + b.y) / 2;

  return s;
}



/* Funkcija main */
int main ()
{
  struct tacka a, b;
  struct tacka s;
  double d;

  /* Unosimo koordinate tacaka a i b i racunamo rastojanje
     i srediste duzi. */

  /* Obratiti paznju na prioritet operatora: operator tacka
     ima visi prioritet od operatora & */

  printf ("Uneti koordinate tacke a: ");
  scanf ("%lf%lf", &a.x, &a.y);

  printf ("Uneti koordinate tacke b: ");
  scanf ("%lf%lf", &b.x, &b.y);


  d = rastojanje (a, b);
  printf ("Rastojanje izmedju tacaka: %f\n", d);

  /* Obratiti paznju na dodelu struktura */

  s = srediste (a, b);
  printf ("Srediste duzi ab je tacka (%f,%f)\n", s.x, s.y);

  return 0;
}
