.intel_syntax noprefix

.text
.global obrni_niz

##
## void obrni_niz(int * a, int n)
##
## Funkcija obrce niz celih brojeva duzine n na ciji
## pocetni element pokazuje a. Argumenti funkcije:
##
## -- int * a -- [ebp + 8]
## -- int n -- [ebp + 12]
##
obrni_niz:

	## Prolog funkcije
	enter 0,0
	push esi
	push edi

	## Registar esi ce sadrzati adresu krajnjeg levog (pocetnog)
	## elementa niza, a zatim cemo ga u svakoj iteraciji pomerati
	## udesno.
	mov esi, [ebp + 8]

	## Registar edi ce sadrzati adresu krajnjeg desnog (krajnjeg)
	## elementa niza, a zatim cemo ga u svakoj iteraciji pomerati
	## ulevo. Adresu krajnjeg desnog elementa izracunavamo tako
	## sto u ecx ucitamo n, zatim ga umanjimo za jedan i pomnozimo
	## sa 4 (tj. dobijemo 4 * (n - 1)). Na kraju to dodamo na
	## adresu pocetnog elementa (iz registra esi). Mnozenje sa
	## 4 se najefikasnije vrsi shift-ovanjem za dve pozicije u levo.
	## Ovo se ostvaruje shl instrukcijom (shiftuje prvi operand za
	## broj pozicija koji je dat kao konstanta drugim operandom).
	## Postoje i slicne instrukcije shr i sar (za, redom, logicko
	## i aritmeticko shift-ovanje u desno).
	mov edi, esi
	mov ecx, [ebp + 12]
	dec ecx
	shl ecx, 2
	add edi, ecx
	
sledeca_zamena:
	## Dok se pokazivaci ne ukrste
	cmp esi, edi
	jae poslednja_zamena

	## Ucitavamo levi u eax, a desni u edx. Zatim ih upisujemo nazad
	## u obrnutom poretku. Koristimo bazno adresiranje.
	mov eax, [esi]
	mov edx, [edi]
	mov [esi], edx
	mov [edi], eax

	## Uvecavamo levi pokazivac, a umanjujemo desni.
	add esi, 4
	sub edi, 4
	jmp sledeca_zamena
poslednja_zamena:	
	

	## Epilog funkcije
	pop edi
	pop esi
	leave
	ret
	
