﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace MVCTest.Models
{
    public class TestModel
    {
        public TestModel()
        {
            CurrentQuestion = 0;
            TotalPoints = 0;
            Questions = new Question[] {
            new Question()
            {
                Text = "Које године је почео Први светски рат?",
                Answers = new string[] { "1912", "1913", "1914" },
                CorrectAnswer = 2,
                Points = 5
            },
            new Question()
            {
                Text = "Која је највећа птица на свету?",
                Answers = new string[] {"Колибри", "Ној", "Орао"},
                CorrectAnswer = 1,
                Points = 5
            },
            new Question()
            {
                Text = "Вредност израза sin^2(x) + cos^2(x) је једнака:",
                Answers = new string[] {"1", "sin(2x)", "cos(x^2)"},
                CorrectAnswer = 0,
                Points = 5
            },
            new Question()
            {
                Text = "Која је најнасељенија држава на свету?",
                Answers = new string[] {"Кина", "САД", "Индија"},
                CorrectAnswer = 0,
                Points = 5
            },
            new Question()
            {
                Text = "Који елемент је најзаступљенији у ваздуху?",
                Answers = new string [] {"Кисеоник","Азот","Водоник"},
                CorrectAnswer = 1,
                Points = 5
            }
            };
        }

        public QuestionViewModel getViewModel()
        {
            QuestionViewModel model = new QuestionViewModel();
            model.Text = Questions[CurrentQuestion].Text;
            model.Answers = Questions[CurrentQuestion].Answers;
            model.Answer = -1;
            return model;
        }

        public class Question
        {
            public string Text { get; set; }
            public string[] Answers { get; set; }
            public int CorrectAnswer { get; set; }
            public int Points { get; set; }
        }

        public Question[] Questions { get; set; }
        public int CurrentQuestion { get; set; }
        public int TotalPoints { get; set; }

        public int MaxPoints
        {
            get
            {
                int sum = 0;
                foreach (Question q in Questions)
                    sum += q.Points;
                return sum;
            }
        }

        public void nextQuestion(int answer)
        {
            if (Questions[CurrentQuestion].CorrectAnswer == answer)
                TotalPoints += Questions[CurrentQuestion].Points;
            CurrentQuestion++;
        }

        public bool isFinished()
        {
            return CurrentQuestion >= Questions.Length;
        }
    }
}