﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using MVCTest.Models;

namespace MVCTest.Controllers
{
    public class HomeController : Controller
    {
        //
        // GET: /Home/
        public ActionResult Index()
        {
            return View();
        }

        [HttpGet]
        public ActionResult Next()
        {
            TestModel testModel = new TestModel();
            QuestionViewModel model = testModel.getViewModel();
            return View(model);
        }

        [HttpPost]
        public ActionResult Next(QuestionViewModel model)
        {
            if(ModelState.IsValid)
            {
                TestModel testModel = new TestModel();
                testModel.TotalPoints = model.TotalPoints;
                testModel.CurrentQuestion = model.CurrentQuestion;
                testModel.nextQuestion(model.Answer);
                if (testModel.isFinished())
                    return RedirectToAction("Result", new { testModel.TotalPoints, testModel.MaxPoints });
                model = testModel.getViewModel();
                ModelState.Clear();
            }
            return View(model);
        }

    public ActionResult Result(int TotalPoints, int MaxPoints)
    {
        ViewBag.TotalPoints = TotalPoints;
        ViewBag.MaxPoints = MaxPoints;
        return View();
    }

    }
}