#include <stdio.h>

/* Program ispituje da li je dati ceo broj savrsen. Za broj kazemo da je 
   savrsen ako je jednak zbiru svojih pravih delilaca (npr. takav je broj
   6, jer je 1 + 2 + 3 == 6) */
int main()
{
  int x, S;
  int i;

  /* Ucitavamo ceo broj */
  scanf("%d", &x);

  /* Postavljamo sumu pravih delilaca na 0 */
  S = 0;
 
  /* Implementacija pomocu while petlje:
  i = 1;
  while(i < x)
    {
      if(x % i == 0)
	S += i;

	i++; 
    }
  */

  /* NAPOMENA: Izraz i++ je skraceni oblik izraza i = i + 1, odnosno i += 1 */

   /* NAPOMENA: Brojacka petlja je petlja u kojoj postoji promenljiva koja
     u svakoj iteraciji uzima po jednu vrednost iz nekog unapred datog skupa. 
     Ova promenljiva se zove "brojac". Uobicajeno je da se ove promenljive 
     imenuju sa i, j, k,... Dakle, telo petlje se izvrsava po jednom 
     za svaku vrednost brojaca iz datog skupa vrednosti. U nasem primeru,
     promenljiva i je uzimala sve vrednosti od 1 do x - 1 redom. S obzirom
     da su ovakve petlje veoma ceste, programski jezik C ima posebnu 
     sintaksu za ovakve petlje:

     for(izraz1; izraz2; izraz3)
       naredba

     Svaki od izraza se moze izostaviti, ali oba simbola ; moraju biti
     prisutna. Naredba u telu petlje moze biti prosta ili slozena. For
     petlja se izvrsava na sledeci nacin: najpre se izracuna prvi izraz
     (uz izvrsenje eventualnih bocnih efekata koje to izracunavanje sa 
     sobom nosi). Nakon toga se izracunava izraz2 koji se tumaci kao uslov
     i ako je taj uslov ispunjen, tada se izvrsava naredba. Nakon toga se
     izracunava izraz3, a onda se ponovo izracunava uslov u izrazu 2, pa
     ako je ponovo ispunjen, ponovo se ulazu u naredbu, pa se ponovo
     izracunava izraz3, pa ponovo uslov u izrazu 2 i tako redom. Kada uslov
     u izrazu 2 vise nije ispunjen, tada se napusta petlja. Drugim recima,
     izvrsavanje gornje for petlje se moze predstaviti sledecom ekvivalentnom
     while petljom:

     izraz1;
     while(izraz2)
     {
       naredba
       izraz3;
     }

     Dakle, izraz1 se izracunava samo jednom. Njegova uloga je najcesce 
     inicijalizacija brojaca (mada ne mora biti). Izraz2 je logicki izraz
     koji se interpretira kao uslov koji se proverava pre svakog izvrsenja
     naredbe (kao i u while-u, i ovo je petlja sa preduslovom). Na kraju 
     svake iteracije (nakon naredbe u telu petlje) izracunava se izraz3. 
     Njegova uloga je najcesce inkrementiranje (ili dekrementiranje) 
     brojacke promenljive. 

     Ako se izostavi izraz1, tada prosto nema inicijalizacije. Ako se 
     izostavi izraz3, tada nema inkrementacije. Tako na primer, petlja:

     for(;uslov;) naredba

     je ekvivalentna while petlji (neka citalac sam analizira zasto).
     Na osnovu ovoga zakljucujemo da su for i while petlje potpuno
     ekvivalentne -- sve sto se moze izraziti jednom, moze i drugom, i 
     obrnuto. Sintaksa for petlje je vise prilagodjena brojackim 
     petljama, dok je sintaksa while petlje jednostavnija. Na programeru
     je da se odluci koju ce kada koristiti. 

     Ako se izostavi izraz2, tada se smatra da je uslov ISPUNJEN. Neka
     citalac sam zakljuci sta radi sledeca petlja:

     for(;;) { }
   */
 

  /* Implementacija pomocu for petlje */
  for(i = 1; i < x; i++)  /* Za svako i od 1 do x - 1 */
    {
      if(x % i == 0) /* Ako je x deljivo sa i */
	S += i;      /* dodati i na sumu S */
    }


  /* Proveravamo da li je broj savrsen */
  if(x == S) 
    printf("Broj je savrsen!\n");
  else
    printf("Broj nije savrsen!\n");


  return 0;
}
