#include <stdio.h>

/* Program odredjuje sumu dekadnih cifara datog prirodnog broja */
int main()
{
  int x, S;

  /* Ucitavamo broj x */
  scanf("%d", &x);

  /* U promenljivoj S izracunavamo sumu dekadnih cifara. Zbog toga se ova
     promenljiva mora inicijalizovati na 0. Ovo je po pravilu slucaj u 
     svim algoritmima koji izracunavaju sume. Analogno, ako se izracunava 
     proizvod vrednosti, tada se vrednost proizvoda inicijalno postavlja na
     vrednost 1, zato sto je 1 neutralni element za operaciju mnozenja. */
  S = 0;

  /* NAPOMENA:
     Naredba:
     
     while(uslov) naredba

     je slozena naredba koja predstavlja PETLJU SA PREDUSLOVOM. Izvrsava
     se na sledeci nacin: najpre se ispita uslov; ako je uslov ispunjen,
     izvrsava se naredba, nakon cega se ponovo proverava uslov. Ako je 
     uslov ponovo ispunjen, ponovo se izvrsava naredba, i tako dalje. 
     Kada uslov vise ne bude ispunjen, naredba se vise ne izvrsava a petlja
     se zavrsava. Primetimo da se kod while petlje moze dogoditi da se 
     naredba u telu petlje ne izvrsi ni jedno -- ako uslov u startu nije 
     ispunjen, petlja se odmah zavrsava bez izvrsenja naredbe.
   
     Naredba u telu petlje moze biti prosta ili slozena, kao sto je obicno
     slucaj.
  */
   
  while(x != 0) /* Dokle god postoji bar jos jedna cifra  */
    {
      /* Uvecavamo S za vrednost cifre jedinice u dekadnom zapisu broja x.
	 Ovu cifru mozemo lako izracunati kao ostatak pri deljenju brojem 10.
	 Operator za odredjivanje ostatka pri deljenju je %. */
      S = S + x % 10; /* S += x % 10; */
      
      /* Nakon toga delimo x sa 10 i dobijeni celobrojni kolicnik ponovo 
	 upisujemo u x. Ovim se dobija broj kome je u dekadnom zapisu 
	 obrisana poslednja cifra (npr. 325 / 10 == 32). C prevodilac uvek
	 vrsi celobrojno deljenje ako su operandi operatora / celobrojnog
	 tipa). */
      x = x / 10;     /* x /= 10; */
    }
  
  /* Ispisujemo celobrojni zbir */
  printf("Zbir cifara je: %d\n", S);

  return 0;
}
