#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

/* Deklaracija asemblerske funkcije */
void diff(double * x, double * y, int n, double * r);

int main()
{
  double *x, *y; /* Pokazivaci na nizove realnih brojeva */
  int n;         /* Duzina nizova */
  double r;      /* Rezultat */
  int i;         /* Brojac u petljama */

  /* Ucitavamo duzinu nizova */
  assert(scanf("%d", &n) == 1);
   
  /* Alociramo prostor za nizove */
  assert((x = malloc(sizeof(double) * n)) != NULL);
  assert((y = malloc(sizeof(double) * n)) != NULL);

  /* Unosimo elemente prvog niza */
  for(i = 0; i < n; i++)
    assert(scanf("%lf", &x[i]) == 1);

  /* Unosimo elemente drugog niza */
  for(i = 0; i < n; i++)
    assert(scanf("%lf", &y[i]) == 1);
  
  /* Pozivamo funkciju */
  diff(x, y, n, &r);

  /* Stampamo rezultat */
  printf("%g\n", r);
  
  /* Oslobadjamo prostor za nizove */
  free(x);
  free(y);

  return EXIT_SUCCESS;
}
