﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;

namespace WebApplication4.Models
{
    public class CalculatorModel : IValidatableObject
    {
        // Division by zero validation
        public IEnumerable<ValidationResult> Validate(ValidationContext context)
        {
            if (Y == 0 && Op == "div")
                return new List<ValidationResult>() { new ValidationResult("Division by zero", new string[] { "Y", "Op" }) };
            else
                return new List<ValidationResult>();
        }


        [Required(ErrorMessage="You must specify X")]
        [Display(Name="X: ")] // Specifies label text
        //[Even(ErrorMessage = "Number must be even")]
        public int X { get; set; }

        [Required] // Using default error message
        [Display(Name="Y: ")]
        public int Y { get; set; }

        [RegularExpression("add|sub|mul|div")]
        [Display(Name="Op: ")]
        public string Op { get; set; }

        public int Result { get; set; }
        public string ErrorMessage { get; set; }

        public string ResultMessage
        {
            get
            {
                return "Result is: " + Result;
            }
        }

        public void Calculate()
        {
            switch (Op)
            {
                case "add":
                    Result = X + Y;
                    break;
                case "sub":
                    Result = X - Y;
                    break;
                case "mul":
                    Result = X * Y;
                    break;
                case "div":
                    Result = X / Y;
                    break;
                default:
                    ErrorMessage = "Unknown operation: " + Op;
                    break;
            }
        }
    }
}