﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace WebApplication4.Controllers
{
    public class CalculatorController : Controller
    {
        //
        // GET: /Calculator/
        public ActionResult Index(int? x, string op, int? y)
        {
            if (x == null || y == null || op == null)
                ViewBag.ErrorMessage = "PLEASE SPECIFY PARAMETERS!!";
            else 
            {
                int X = (int)x;
                int Y = (int)y;
                ViewBag.X = X;
                ViewBag.Y = Y;
                ViewBag.Op = op;
                if (op == "add")
                    ViewBag.ResultMessage = X.ToString() + "+" + Y.ToString() + "=" + (X + Y);
                else if (op == "sub")
                    ViewBag.ResultMessage = X.ToString() + "-" + Y.ToString() + "=" + (X - Y);
                else if (op == "mul")
                    ViewBag.ResultMessage = X.ToString() + "*" + Y.ToString() + "=" + (X * Y);
                else if (op == "div")
                    ViewBag.ResultMessage = X.ToString() + "/" + Y.ToString() + "=" + (X / Y);
                else
                    ViewBag.ErrorMessage = "WRONG OPERATION: " + op;
            }
            return View();  
        }
	}
}