#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/* Deskriptivna imena za indekse koordinata tacaka. */
#define X 0
#define Y 1
#define Z 2

/* Deklaracija funkcije center_of_mass(). */
void  center_of_mass(int n, float *P, float *m, float *C);

int main()
{
  int    n;	/* Broj zadatih cestica. */
  float  *P;	/* Polje sa koordinatama cestica. */
  float  *m;	/* Polje sa masama cestica. */
  float  C[3];	/* Koordinate centra mase sistema. */
  int    i;	/* Brojac u petljama. */

  /* Ucitava se broj cestica, a zatim se alocira memorija za podatke 
     o istim. */
  scanf("%d", &n);
  assert(n > 0);
  P = malloc(3 * n * sizeof(float));
  assert(P != NULL);
  m = malloc(n * sizeof(float));
  assert(m != NULL);
  
  /* Ucitavaju se podaci o cesticama. */
  for (i = 0; i < n; i++) {
    scanf("%f%f%f%f", &P[3 * i + X], &P[3 * i + Y], &P[3 * i + Z], &m[i]);
    assert(m[i] > 0);
  }
  
  /* Izracunavaju se i stampaju koordinate centra mase datog
   * sistema. */
  center_of_mass(n, P, m, C);
  printf("%g %g %g\n", C[X], C[Y], C[Z]);
  
  /* Oslobadja se memorija koriscena za podatke o cesticama. */
  free(P);
  free(m);
  
  return 0;
}
