.intel_syntax noprefix

.text
.global center_of_mass

############################################################################
##
## Funkcija:
## void  center_of_mass(int n, float *P, float *m, float *C);
##
## izracunava centra mase datog sistema cestica.  Argumenti funkcije su:
##
##  -- int n -- [ebp+8] -- broj cestica u sistemu
##  -- float *P -- [ebp+12] -- adresa prvog elementa u polju sa
##     koordinatama cestica
##  -- float *m -- [ebp+16] -- adresa prvog elementa u polju sa masama
##     cestica
##  -- float *C -- [ebp+20] -- adrese na koju treba smestiti koordinate
##     centra mase sistema
##
## Pretpostavka je da je broj cestica u sistemu veci od 0, kao i da su
## mase svih cestica vece od 0.
##
############################################################################
center_of_mass:
        ## Prolog funkcije.
	enter   16, 0
        push    ebx
        push    esi
        push    edi

        ## Proverava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz not_supported

        ## Cuva se sadrzaj SSE registara i registara koprocesora.
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

        ## Registar ecx ce biti koriscen kao brojac.  Registar esi ce
        ## sadrzati adresu na kojoj su smestene koordinate tekuce
        ## cestice, a registar ebx adresu na kojoj se nalazi masa tekuce
	## cestice.
        cld
        mov     ecx, [ebp+8]
        mov     esi, [ebp+12]
        mov     ebx, [ebp+16]

        ## Registri xmm0 i xmm1 ce sadrzati, respektivno, tekucu sumu
        ## koordinata cestica skaliranih njihovim masama, odn. tekucu
	## sumu masa cestica.
        xorps   xmm0, xmm0
        xorps   xmm1, xmm1
        
next_particle:        
        ## Preko pomocnog niza, u registar xmm2 se upisuju koordinate
	## tekuce cestice.
        mov     eax, ecx
        mov     ecx, 3
        lea     edi, [ebp-16]
        rep movsd
        movups  xmm2, [ebp-16]
        mov     ecx, eax

        ## U registar xmm3 se upisuje masa tekuce cestice, koja se
	## istovremeno nadodaje na ukupnu masu sistema.
        movss   xmm3, [ebx]
        add     ebx, 4
        addss   xmm1, xmm3

        ## Skaliraju se koordinate tekuce cestice vrednoscu njene
        ## mase, i nadodaju se tako dobijene vrednosti na odgovarajuce
	## parcijalne sume.
        shufps  xmm3, xmm3, 0b00000000
        mulps   xmm2, xmm3
        addps   xmm0, xmm2

        ## Prelazi se na sledecu cesticu.
        loop next_particle

        ## Izracunavaju se finalne koordinate centra mase sistema.
        shufps  xmm1, xmm1, 0b00000000
        divps   xmm0, xmm1

        ## Upisuju se koordinate centra mase u za to predvidjene lokacije
        movups  [ebp-16], xmm0
        mov     ecx, 3
        lea     esi, [ebp-16]
        mov     edi, [ebp+20]
        rep movsd

        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
        ## registre.
        fxrstor [esp]
        mov     esp, edx

done:
	## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
	leave
        ret

not_supported:
        ## Ako SSE instrukcije nisu podrzane, prekidamo program exit(1)
        ## pozivom.
        mov eax, 1
        mov ebx, 1
        int 0x80
	