.intel_syntax noprefix

.data
ten:	.int 10      ## Broj 10
		
.text
.global add

##########################################################################
##
## Funkcija:
##    void add(char *x, char *y, char *r);
##
##  vrsi sabiranje dva velika pozitivna cela broja cije su dekadne cifre
##  date u stringovima x i y, i rezultat smesta u istom formatu u string
##  r. Argumenti funkcije su:
##
## -- char * x -- [ebp+8] -- prvi sabirak.
## -- char * y -- [ebp+12] -- drugi sabirak.
## -- char * r -- [ebp+16] -- adresa na koju se smesta zbir.
##
##########################################################################
add:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

	## Postavljamo smer kretanja kroz stringove.
	cld

	## Krecemo se kroz prvi string do njegovog kraja (do terminirajuce
	## nule). 
	mov edi, [ebp + 8]
	xor eax, eax
search_end_x:	
	scasb
	je end_x_found
	jmp search_end_x
end_x_found:	
	
	## Izracunavamo adresu pozicije poslednjeg karaktera u prvom stringu,
	## i smestamo je u esi.
	sub edi, 2
	mov esi, edi

	## Krecemo se kroz drugi string do njegovog kraja (do terminirajuce
	## nule). 
	mov edi, [ebp + 12]
	xor eax, eax
search_end_y:	
	scasb
	je end_y_found
	jmp search_end_y
end_y_found:	
	
	## Izracunavamo adresu pozicije poslednjeg karaktera u drugom stringu.
	sub edi, 2

	## U ebx smestamo adresu niza u koji se upisuje rezultat.
	mov ebx, [ebp + 16]

	## Registar ecx ce sadrzati prethodni prenos.
	xor ecx, ecx

	## U petlji add_loop se krecemo unazad kroz oba stringa i sabiramo
	## odgovarajuce cifre.
add_loop:
	## Anuliramo registre eax i edx.
	xor eax, eax
	xor edx, edx

	## Proveravamo da li smo upotrebili sve cifre prvog broja. 
	cmp esi, [ebp + 8]
	jl first_finished

	## Ako nismo, onda ucitavamo tekucu cifru prvog broja u registar al.
	mov al, [esi]
	sub al, '0'
	dec esi

	## Proveravamo da li smo upotrebili sve cifre drugog broja (pod
	## pretpostavkom da nismo upotrebili sve cifre prvog broja).
	cmp edi, [ebp + 12]
	jl second_finished

	## Skok na ucitavanje cifre drugog broja.
	jmp load_y

first_finished:
	## Proveravamo da li smo upotrebili sve cifre drugog broja (pod
	## pretpostavkom da smo upotrebili sve cifre prvog broja).
	cmp edi, [ebp + 12]

	## Ako jesmo, sabiranje je zavrseno.
	jl both_finished
	
load_y:
	## Ucitavanje cifre drugog broja u registar dl.
	mov dl, [edi]
	sub dl, '0'
	dec edi

second_finished:
	## Sabiranje cifara, uz prethodni prenos.
	add al, dl
	add eax, ecx

	## Proveravamo da li ima prenosa.
	cmp eax, 10
	jl no_carry

	## Ako ima, postavljamo ecx na 1, a cifru odredjujemo oduzimanjem
	## broja 10 od zbira.
	mov ecx, 1
	sub eax, 10
	jmp store
	
no_carry:
	## Postavljamo ecx na 0.
	xor ecx, ecx
	
store:	
	## Upisujemo cifru u rezultujuci niz.
	add al, '0'
	mov [ebx], al
	inc ebx

	## Sledeca iteracija.
	jmp add_loop

	
both_finished:	
	## Ako je nakon poslednjeg sabiranja ostao prenos, treba upisati
	## jos jednu jedinicu.
	jecxz skip
	mov byte ptr [ebx], '1'
	inc ebx

	## Upisujemo terminirajucu nulu.
skip:	
	mov byte ptr [ebx], 0

	
	## Izracunavamo adresu pozicije poslednjeg karaktera u rezultujucem
	## stringu i smestamo je u esi.
	mov esi, ebx
	sub esi, 1

	## Ucitavamo adresu pocetka rezultujuceg stringa u edi.
	mov edi, [ebp + 16]

	## Petlja u kojoj se obrce rezultujuci string (s obzirom da su cifre
	## u obrnutom poretku).
reverse_r:
	cmp edi, esi
	jge done
	mov al, [edi]
	mov ah, [esi]
	mov [esi], al
	mov [edi], ah
	inc edi
	dec esi
	jmp reverse_r

done:	
        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret
