#include <stdio.h>

typedef union {
  unsigned d;
  float f;
} FD;

void float_mnozenje(float x, float y, float * R)
{
  FD fdx, fdy, fdr;
  unsigned mx, my, m;
  unsigned sx, sy, s;
  int ex, ey, e;

  /* Ucitavamo u unijske promenljive vrednosti brojeva x i y. Na dalje ce
     ovim vrednostima biti pristupano preko clana d, koji je tipa unsigned */
  fdx.f = x;
  fdy.f = y;

  /* Ako je bilo koji od cinilaca nula ili denormalizovan, tada smatramo da
     je proizvod 0 */
  if((fdx.d & 0x7F800000) == 0 || (fdy.d & 0x7F800000) == 0)
    {
      *R = 0;
      return;
    }
  
  /* Izdvajamo bitove mantise, a zatim ukljucujemo i implicitnu jedinicu. */
  mx = (fdx.d & 0x7FFFFF) | 0x800000;
  my = (fdy.d & 0x7FFFFF) | 0x800000;

  /* Odredjujemo vrednosti eksponenata */
  ex = (int)((fdx.d & 0x7F800000) >> 23) - 127;
  ey = (int)((fdy.d & 0x7F800000) >> 23) - 127;
  
  /* Izdvajamo bitove znaka */
  sx = (fdx.d & 0x80000000);
  sy = (fdy.d & 0x80000000);
  
  /* Znak je jednak 1 akko su znakovi sx i sy razliciti */
  s = sx ^ sy;

  /* Mantisa se dobija tako sto pomnozimo mantise cinilaca. Kako se mnozenjem
     24-bitnih celih brojeva moze u opstem slucaju dobiti 48-bitni proizvod,
     jasno je da to ne moze da se izvede pomocu C-ovog operatora * za 
     unsigned tip. Zato cemo ovde koristiti tip unsigned long long, koji
     je 64-bitni ceo broj (ovaj tip je uveden u standard C-a 99-te godine). 
     Dobijeni rezultat ima 48 cifara, od kojih su 46 decimale, a (najvise)
     dva bita su celobrojni deo, Zato ovo pomeramo u desno za 23 pozicije,
     kako bismo ostavili samo visih 23 decimala, poravnatih na desnom 
     kraju. Najzad, ponovo ovo konvertujemo u unsigned (sto je moguce, 
     zato sto ce rezultat nakon brisanja 23 manje znacajne decimale imati 
     najvise 25 znacajnih cifara). */
  m = (unsigned)(((unsigned long long) mx * (unsigned long long) my) >> 23);

  /* Eksponent je jednak zbiru eksponenata. */
  e = ex + ey;
  
  /* U nastavku vrsimo normalizaciju. Ako je m 25-bitna vrednost (tj.
     ako proizvod mantisa ima dve cifre u celobrojnom delu),
     tada se m pomera u desno za jednu poziciju, a eksponent uvecava 
     za jedan. */
  if(m & 0xFF000000)
    {
      m >>= 1;
      e++;
      
      /* Ako je nakon uvecanja eksponent >= 128, tada je doslo do prekoracenja.
	 Rezultat je beskonacna vrednost, koja se predstavlja maksimalnim
	 eksponentom i mantisom jednakom 0 */
      if(e >= 128)
	{
	  m = 0;
	  e = 128;
	}
    }
  
  /* Iskljucujemo implicitni bit 23 */
  m &= 0x7FFFFF;
  
  /* Upisujemo mantisu i eksponent */
  fdr.d = m;
  fdr.d |= (unsigned)(e + 127) << 23;
  
  fdr.d |= s;

  /* Upisujemo rezultat u za to predvidjenu lokaciju */
  *R = fdr.f;
  
}

int main()
{

  float x, y, R;

  scanf("%f%f", &x, &y);

  float_mnozenje(x, y, &R);

  printf("Rezultat: %g\n", R);
  printf("Provera:  %g\n", x * y);
  return 0;
}
