#include <stdio.h>

/* 32-bitni unijski tip koji moze da cuva float ili unsigned */
typedef union {
  float f;
  unsigned d;
} FD;

typedef union {
  double lf;
  unsigned long long d;
} LFLD;

void float_u_double(float x, double * y)
{
  FD fdx;
  LFLD lfdy;
  unsigned m, e, s;

  fdx.f = x;
  
  s = fdx.d & 0x80000000; /* Izdvajamo znak */
  m = fdx.d & 0x7fffff;  /* Izdvajamo mantisu */
  e = (fdx.d & 0x7f800000) >> 23; /* Izdvajamo eksponent */

  lfdy.d = (unsigned long long)s << 32; /* Upisujemo znak */
  lfdy.d |= (unsigned long long)m << 29; /* Upisujemo mantisu */
  lfdy.d |= (unsigned long long)(e + (1023 - 127)) << 52; /* Upisujemo
							     eksponent */

  /* Upis double vrednosti u *y */
  *y = lfdy.lf;
}

/* NAPOMENA: Student za vezbu moze da implementira funkciju double_to_float()
   koja vrsi obrnutu konverziju. Primetimo da se tom prilikom mantisa skracuje
   sa 52 na 23 bita, sto moze da uzrokuje gubitak znacajnih cifara. */



int main()
{

  float f;
  double lf;

  scanf("%f", &f);

  float_u_double(f, &lf);

  printf("%f\n", lf);

  printf("Provera: %f\n", (double)f);

  return 0;
}
