.intel_syntax noprefix

.data
start_value: .double 0.75

.text
.global fourier
	
###############################################################################
# double fourier(double x, int n); 
#
# double x -- [ebp+8] -- tacka u kojoj se racuna vrednost
# int n -- [ebp+16] -- stepen parcijalne sume
# 
###############################################################################

fourier:
	## Prolog funkcije.
	enter 0,0

	## U registar ecx upisujemo broj n.
	mov ecx, [ebp+16]

	## Smestamo na fpu-stek pocetnu vrednost sume (3/4) kao i vrednost
	## x u kojoj racunamo funkciju.
	fld qword ptr start_value ## stek: 3/4 = S
	fld qword ptr [ebp+8]	## stek: S,x
	
	## Ako je n == 0, tada nema iteracija.
	jecxz finish
	
	## U petlji racunamo sumu pocev od n-tog sabirka sume.
	
				## stek: S,x
next:
	fldpi			## stek: S,x,pi
	push ecx
	fimul dword ptr [esp]	## stek: S,x,k*pi
	add esp,4
	fld st			## stek: S,x,k*pi,k*pi
	fmul st, st(2)		## stek: S,x,k*pi,k*pi*x

	## Proveravamo parnost tekuceg indeksa.
	test ecx, 0x1
	jz even

	## U slucaju da je k neparno, tada racunamo oba sabirka 
odd:	
	fsincos			## stek: S,x,k*pi,sin(k*pi*x),cos(k*pi*x)
	fdiv st(0), st(2)	## stek: S,x,k*pi,sin(k*pi*x),cos(k*pi*x)/(k*pi)
	fdiv st(0), st(2)	## stek: S,x,k*pi,sin(k*pi*x),cos(k*pi*x)/(k*pi)^2
	fadd st(0), st(0)	## stek: S,x,k*pi,sin(k*pi*x),2*cos(k*pi*x)/(k*pi)^2
	fsubp st(4), st(0)	## stek: S,x,k*pi,sin(k*pi*x)
	fdivrp st(1), st(0)	## stek: S,x,sin(k*pi*x)/(k*pi)
	fsubp st(2), st(0)	## stek: S,x

	## Prelazimo na sledecu iteraciju
	loop next

	jmp finish
	
	## Ako je k parno, racunamo samo drugi sabirak
even:	
	fsin			## stek: S,x,k*pi,sin(k*pi*x)
	fdivrp st(1), st(0)	## stek: S,x,sin(k*pi*x)/(k*pi)
	fsubp st(2), st(0)	## stek: S,x

	## Prelazimo na sledecu iteraciju.
	loop next

finish:
	## Uklanjamo sa steka nepotrebne vrednosti.
	fcomp			## stek: S
	
done:
	## Epilog funkcije.
	leave
	ret
	