#include <stdio.h>
#include <stdlib.h>

#define MAX_CVOROVA 100

/* NAPOMENA: Jasno je da se usmerenim grafovima
   moze predstavljati binarna relacija na nekom
   konacnom skupu. Cvorovi grafa su elementi tog
   skupa, dok ce grana izmedju u i v postojati 
   akko je (u,v) u relaciji. Primenom teorije 
   grafova mogu se resavati i neki problemi 
   vezani za relacije. Jedan takav primer je 
   izlozen  u ovom programu, gde se odredjuje tzv.
   tranzitivno zatvorenje relacije -- najmanji 
   nadskup date relacije koji ima osobinu 
   tranzitivnosti. */


int graf[MAX_CVOROVA][MAX_CVOROVA];
int broj_cvorova;

/* Algoritam koji vrsi tranzitivno zatvorenje grafa, tj.
   relacije koju ovaj graf predstavlja. */
void Warshall()
{
   int i, j, k;

   /* Za svaka dva cvora i i j gledamo da li postoji 
      cvor k preko koga su povezani, i u tom slucaju 
      dodajemo granu (i,j) */
   for(i = 0; i < broj_cvorova; i++)
    for(j = 0; j < broj_cvorova; j++)
     for(k = 0; k < broj_cvorova; k++)
       if(graf[i][k] && graf[k][j])
        {
          graf[i][j] = 1;
          break;
        }

}

int main()
{

int i, j;

/* Unos matrice povezanosti grafa */
printf("Unesite broj cvorova grafa (<=%d): ", MAX_CVOROVA);
scanf("%d",&broj_cvorova);

for(i = 0; i < broj_cvorova; i++)
  for(j = 0; j < broj_cvorova; j++)
    {
      printf("Da li postoji grana (%d,%d) (0/1): ", i, j);
      scanf("%d", &graf[i][j]);
    }

/* Prikaz originalnog grafa */
printf("Originalni graf:\n");

for(i = 0; i < broj_cvorova; i++)
 {
  for(j = 0; j < broj_cvorova; j++)
    printf("%d ", graf[i][j]);
  putchar('\n');
 }

/* Poziv tranzitivnog zatvorenja */
Warshall();

/* Prikaz tranzitivnog zatvorenja */
printf("Tranzitivno zatvorenje grafa:\n");

for(i = 0; i < broj_cvorova; i++)
 {
  for(j = 0; j < broj_cvorova; j++)
    printf("%d ", graf[i][j]);
  putchar('\n');
 }


return 0;
}
