.intel_syntax noprefix

	## NAPOMENA: Komentari se u asembleru obelezavaju znakom #. Sve pocev
	## od tog znaka pa do kraja linije se ignorise.

	## NAPOMENA: Asemblerski kod se sastoji asemblerskih direktiva i
	## instrukcija. Direktive se razlikuju od instrukcija po tome sto
	## pocinju tackom. Direktive obicno ne proizvode kod (mada mogu
	## emitovati bajtove, npr. kod direktiva za deklarisanje podataka)
	## vec najcesce opisuju nacin na koji se obavlja prevodjenje. Npr.
	## gornja direktiva .intel_syntax oznacava da se koristi Intel-ova
	## sintaksa asemblera. Asemblerske instrukcije se prevode tako sto
	## se u rezultujuci objektni fajl emituju bajtovi koji predstavljaju
	## ekvivalentnu masinsku instrukciju. 
	
.text
	## NAPOMENA: Direktiva .text oznacava pocetak zone sa instrukcijama.
	## Analogno, postoji direktiva .data koja oznacava pocetak zone sa
	## statickim inicijalizovanim podacima.

	## NAPOMENA: Masinskim adresama u asembleru odgovaraju LABELE. Labela
	## je identifikator za kojim sledi dvotacka. Labela se mora nalaziti
	## na pocetku linije (uz eventualne vodece beline). Labeli se
	## pridruzuje adresa koja odgovara onome sto sledi neposredno nakon
	## te labele (instrukcija ili podatak). Labela se moze koristiti
	## u instrukcijama kao MEMORIJSKI OPERAND -- svako referisanje na
	## labelu u instrukcijama se prilikom prevodjenja na masinski jezik
	## zamenjuje adresom koja odgovara toj labeli.
	
.global saberi
	## NAPOMENA: Direktiva .global oznacava da se labela add moze
	## koristiti od strane linker-a prilikom povezivanja sa ostalim
	## objektnim fajlovima, tj. da funkcije iz drugih fajlova mogu
	## vrsiti skokove na tu labelu. Ovo je korisno kod pozivanja funkcija,
	## pa se zato obicno labela koja oznacava pocetak funkcije oznacava
	## kao globalna.


## Funkcija:
##
##  	int saberi(int x, int y)
##
## sabira brojeve x i y. Parametri funkcije:
##
## -- int x -- [ebp + 8]
## -- int y -- [ebp + 12]
##
saberi:
	## NAPOMENA: U sladu sa C-konvencijama, prilikom prevodjenja
	## C-funkcije uvek se kreira labela koja se zove isto kao i data
	## C-funkcija i od nje pocinje kod koji nastaje prevodjenjem te
	## funkcije. Ovih konvencija moramo i mi da se drzimo kada pisemo
	## asemblerske funkcije koje treba povezati sa C-kodom (pozivati
	## ih iz C-koda).

	## Prolog funkcije
	push ebp
	mov ebp, esp

	## NAPOMENA: U skadu sa Intel-ovom sintaksom, odredisni operand
	## instrukcije se uvek navodi kao PRVI operand. Tako, instrukcija
	## mov ebp, esp kopira sadrzaj registra esp u ebp, dok instrukcija
	## add eax, ebx sabira registre eax i ebx i zbir smesta u eax.

	## NAPOMENA: Procesori Intel-ove arhitekture imaju 8 registara
	## opste namene. To su: eax, ebx, ecx, edx, esi, edi, esp i ebp.
	## Neki od ovih registara imaju specijalne uloge (o tome vise
	## reci u nastavku). Svi ovi registri su 32-bitni.
	
	## NAPOMENA: Adresa vrha steka se tokom izvrsavanja programa cuva u
	## registru esp. Vrednost ovog registra (a samim tim i adresa vrha
	## steka) se moze menjati uobicajenim instrukcijama opste namene, kao
	## i za sve ostale registre. Takodje, ovaj registar se menja i
	## implicitno, od strane instrukcija za rad sa stekom (push, pusha,
	## pop, popa) kao i instrukcija za rad sa potprogramima (enter, leave,
	## call i ret). Stek na Intel-ovoj arhitekturi "raste" prema NIZIM
	## adresama, tako da se prilikom dodavanja podataka na stek esp
	## registar umanjuje, dok se prilikom skidanja sa steka esp registar
	## uvecava. 
	
	
	## NAPOMENA: Instrukcija push ebp smesta vrednost registra ebp
	## na vrh steka (automatski azurirajuci vrednost pokazivaca vrha
	## steka, tj. registar esp)
	
	## NAPOMENA: Registar ebp cuva adresu tekuceg OKVIRA STEKA
	## (engl. stack frame). Svaki aktivni poziv funkcije ima svoj okvir
	## steka -- to je zona steka u kojoj se nalaze lokalne promenljive
	## i podaci koji odgovaraju tom pozivu. Adresa pocetka okvira tekuceg
	## poziva je bitna, zato sto se u odnosu na nju lako odredjuju
	## relativne pozicije parametara i lokalnih podataka.

	## NAPOMENA: Memorijski operandi se u asemblerskim instrukcijama mogu
	## specificirati na vise nacina. Najjednostavniji nacin je u prostom
	## navodjenju labele (tzv. direktno adresiranje). Ovo je slucaj kada
	## koristimo staticke podatke (iz data sekcije) koji upravo i imaju
	## definisanu labelu koja predstavlja njihovu (fiksnu) adresu u
	## memoriji. Medjutim, ovo nije odgovarajuci nacin kada se radi sa
	## podacima na steku (lokalni automatski podaci i parametri funkcija)
	## Ovi podaci nemaju fiksiranu adresu, pa se njihova adresa odredjuje
	## relativno u odnosu na tekuci okvir steka. Zato je potrebno
	## omoguciti programeru da navede memorijski operand u obliku
	## bazna_adresa +/- pomeraj. U ovu svrhu se koristi tzv.
	## bazno adresiranje: u registar se upise adresa, a onda se kao
	## operand navede naziv tog registra u velikim zagradama ([]). Npr:
	##
	##  mov eax, [ebx]
	##
	## ce ucitati u registar eax podatak iz memorije koji se nalazi na
	## adresi koja je sadrzana u registru ebx (bazna adresa). Slozeniji
	## oblik je npr:
	##
	## mov eax, [ebx + 4]
	##
	## cime se ucitava u eax podatak iz memorije koji se nalazi na adresi
	## ebx + 4 (tj. na baznu adresu iz ebx-a se dodaje pomeraj 4). Na ovaj
	## nacin je omoguceno da se u fazi izvrsenja programa u neki registar
	## upise adresa (npr. adresa neke pozicije na steku), a da se onda
	## relativno u odnosu na tu adresu uzimaju podaci iz memorije.
	
	## NAPOMENA: izgled steka prilikom poziva funkcije add:
	##
	##   ebp   -->    | ---- |  -- pocetak okvira steka prethodne funkcije
	##                | ---- |
	##   ...            ....
	##		  |   y  |
	##		  |   x  |
	##   esp   -->    |  RET |  -- povratna adresa
	##
	## Primetimo da se parametri funkcije uvek stavljaju na stek u
	## obrnutom poretku (tako da prvi parametar x bude "najblizi" vrhu
	## steka). Stavljanje parametara na stek obavlja pozivajuca funkcija
	## (u nasem slucaju funkcija main() )
	##
	## Nakon instrukcije push ebp stek izgleda ovako:
	##
	##   ebp   -->    | ---- |  -- pocetak okvira steka prethodne funkcije
	##                | ---- |
	##   ...            ....
	##		  |   y  |
	##		  |   x  |
	##                |  RET |  -- povratna adresa
	##   esp   -->    |  EBP |  -- adresa okvira steka prethodne funkcije
	##
	## Nakon instrukcije mov ebp, esp obelezava se novi okvir steka koji
	## odgovara funkciji add:
	##
	##                | ---- |  -- pocetak okvira steka prethodne funkcije
	##                | ---- |
	##   ...            ....
	##		  |   y  |
	##		  |   x  |
	##                |  RET |  -- povratna adresa
	## esp, ebp -->   |  EBP |  -- adresa okvira steka prethodne funkcije
	##
	## U toku izvrsvanje funkcije, pokazivac steka esp moze da se pomera
	## (ako se novi lokalni podaci dodaju na stek) ali se ebp ne pomera
	## vec konstantno pokazuje na pocetak okvira steka, tako da se u
	## odnosu na tu baznu adresu relativno odredjuju adrese parametara
	## funkcije i lokalnih podataka. Na primer, podatak x se nalazi
	## na adresi [ebp + 8], dok se y nalazi na adresi [ebp + 12] (stek
	## raste prema nizim adresama). Ako bi postojali lokalni podaci (u
	## ovoj jednostavnoj funkciji ih nema) oni bi se nalazili ispod
	## EBP-a, tj. u okviru okvira steka tekuce funkcije. Npr. ako nam
	## treba dva int-a (a i b) kao lokalni podaci, tada cemo prostor za
	## njih (8 bajtova) rezervisati na steku na sledeci nacin:
	##
	## sub esp, 8
	##
	## Nakon ovoga, stek izgleda ovako:
	##
	##                | ---- |  -- pocetak okvira steka prethodne funkcije
	##                | ---- |
	##   ...            ....
	##		  |   y  |
	##		  |   x  |
	##                |  RET |  -- povratna adresa
	## ebp   -->      |  EBP |  -- adresa okvira steka prethodne funkcije
	## 		  |   a  |
	## esp   -->      |   b  |  -- lokalni podaci (neinicijalizovani)
	##
	## Sada je jasno zasto se u C-u lokalni podaci ne inicijalizuju --
	## oni se kreiraju na steku prostim pomeranjem pokazivaca steka na
	## dole za odgovarajuci broj bajtova. Lokalnim podacima na steku
	## se takodje pristupa relativno u odnosu na pocetak okvira steka
	## tekuce funkcije -- podatak a se nalazi na adresi ebp - 4, dok
	## se podatak b nalazi na adresi ebp - 8.
	
	## NAPOMENA: Po konvenciji, povratna vrednost celobrojnog ili
	## pokazivackog tipa vraca se preko registra eax -- pozvana funkcija
	## samo treba da u ovom registru ostavi povratnu vrednost, pozivajuca
	## funkcija ce je pokupiti odatle.
	
	## Premestamo u eax prvi parametar i zatim na to dodajemo drugi
	## parametar.
	mov eax, [ebp + 8]
	add eax, [ebp + 12]
	
	## NAPOMENA: instrukcija mov premesta drugi operand u prvi.
	## NAPOMENA: instrukcija add sabira svoja dva operanda i zbir
	## smesta u prvi.
	
	## Epilog funkcije
	pop ebp
	ret

	## NAPOMENA: Instrukcija pop ebp skida sa vrha steka jednu
	## cetvorobajtnu vrednost (azurirajuci automatski adresu vrha steka
	## u esp registru) i smesta je u registar ebp.

	## NAPOMENA: Instrukcija pop ebp u nasem slucaju stek svodi na slucaj
	## kao pre instrukcija:
	##
	##  push ebp 
	##  mov ebp, esp
	##
	## tj. u ebp vraca adresu starog okvira steka koja je bila sacuvana na
	## steku, cime se restauira stari okvir steka (pozivajuce funkcije).

	## NAPOMENA: Instrukcija ret skida sa vrha steka jednu cetvorobajtnu
	## vrednost i vrsi bezuslovni skok na adresu datu tom vrednoscu. U
	## nasem slucaju, ona ce sa steka skinuti upravo povratnu adresu i
	## skocice na nju. Time se vracamo u funkciju iz koje smo pozvali
	## funkciju add.
