.intel_syntax noprefix

.data

## NAPOMENA: Direktiva .asciz emituje niz bajtova koji prestavljaju
## ASCII kodove karaktera u stringu koji sledi. Nakon toga se dodaje
## jos i terminirajuca nula (nula bajt). U donjem slucaju ce se pocev
## od adrese obelezene labelom rdfmt nalaziti bajtovi stringa "%d %d"
## dok ce od adrese obelezene labelom wrfmt pocinjati bajtovi stringa
## "%d\n".
rdfmt:  .asciz "%d %d"
wrfmt:	.asciz "%d\n"

## NAPOMENA: Direktiva .int emituje cetvorobajtni zapis celog broja datog
## konstantom koja sledi.
x:	.int 0
y:	.int 0
	
.text
.global main
	
main:
	## Prolog funkcije
	enter 0,0

	## NAPOMENA: Instrukcija enter n, 0 je ekvivalentna sledecem nizu
	## instrukcija:
	##
	## push ebp
	## mov ebp, esp
	## sub esp, n
	##
	## gde je n neka konstanta. Ovim se obelezava okvir steka tekuce
	## funkcije i rezervise n bajtova za lokalne podatke.
	
	## NAPOMENA: Insrukcija LEA (Load Efective Address) ucitava u registar
	## koji je dat kao prvi operand ADRESU koja je data kao drugi operand.
	## Ovo treba razlikovati od instrukcije MOV koja PODATAK sa date
	## adrese ucitava u prvi operand. Dakle, ako napisemo:
	##
	## mov eax, y
	##
	## tada ce se podatak na adresi (labeli) y ucitati u eax, a ako
	## napisemo:
	##
	## lea eax, y
	##
	## tada se sama adresa koja odgovara labeli y ucitava u eax. Slicno
	## instrukcija:
	##
	## lea eax, [ebp + 8]
	##
	## ucitava u registar eax samu adresu ebp + 8 (bazna adresa plus
	## pomeraj) dok instrukcija:
	##
	## mov eax, [ebp + 8]
	##
	## ucitava u eax podatak sa adrese ebp + 8.
	##
	

	## NAPOMENA: Instrukcija CALL funkcionise kao instrukcija bezuslovnog
	## skoka na adresu datu labelom. Medjutim, pre skoka instrukcija CALL
	## postavlja na stek adresu instrukcije koja sledi neposredno nakon
	## nje (povratna adresa). Ova adresa se kasnije koristi od strane
	## instrukcije RET da bi se vratili na mesto neposredno nakon poziva.

	## Poziva se funkcija scanf("%d %d", &x, &y)
	## Ucitava se adresa y u eax, a zatim se ista stavlja na stek.
	lea eax, y
	push eax
	## Ucitava se u eax adresa x, a zatim se ista stavlja na stek.
	lea eax, x
	push eax
	## Ucitava se u eax aresa rdfmt a zatim se ista stavlja na stek.
	lea eax, rdfmt
	push eax
	## Poziva se funkcija scanf() (njoj odgovara istoimena labela)
	call scanf
	## Nakon povratka iz funkcije scanf() moramo da skinemo sa steka
	## parametre funkcije -- ovo se radi prostim dodavanjem 12 na
	## pokazivac steka (cime se vrh steka "pomera" na gore za 12 bajtova).
	add esp, 12

	## NAPOMENA: Ako instrukcija nema ni jedan registarski operand, tada
	## ona ne moze odrediti sirinu operanda koja se zeli koristiti
	## (operandi mogu biti 1-bajtni, 2-bajtni ili 4-bajtni). Zato se u
	## tom slucaju ispred memorijskog operanda stavlja prefix: byte ptr,
	## word ptr, ili dword ptr kako bi se specificirala sirina od
	## 1 bajta, 2 bajta ili 4 bajta respektivno (u Intel-ovoj
	## terminologiji REC (word) je 2-bajtni podatak, dok je DVOSTRUKA
	## REC (double word) 4-bajtni podatak, pomalo suprotno intuiciji).
	
	## Poziva se funkcija saberi(x, y)
	## Postavljamo na stek 4-bajtni podatak sa adrese y
	push dword ptr y
	## Postavljamo na stek 4-bajtni podatak sa adrese x
	push dword ptr x
	## Pozivamo funkciju saberi()
	call saberi
	## Skidamo sa steka dva 4-bajtna podatka.
	add esp, 8

	## Poziva se funkcija printf("%d\n", saberi(x,y))
	## Postavljamo na stek vrednost povratne adrese funkcije saberi().
	push eax
	## Ucitavamo u eax adresu pocetka format stringa wrfmt, a zatim
	## istu postavljamo na stek.
	lea eax, wrfmt
	push eax
	## Pozivamo funkciju printf()
	call printf
	## Skidamo sa steka parametre funkcije printf().
	add esp, 8

	## Epilog funkcije
	xor eax, eax
	leave
	ret

	## NAPOMENA: Instrukcija xor vrsi logicko ekskluzivno ili nad bitovima
	## svojih operanda i dobijeni rezultat smesta u prvi operand. U ovom
	## slucaju ce efekat biti anuliranje registra eax (funkcija main
	## vraca 0).

	## NAPOMENA: Instrukcija leave je ekvivalentna sa:
	##
	## mov esp, ebp
	## pop ebp
	##
	## cime se najpre tekuci okvir steka prazni (pokazivac steka esp se
	## postavlja na pocetak okvira steka na koji pokazuje ebp), a zatim
	## se sa steka skida adresa prethodnog okvira steka i ucitava se
	## u registar ebp.
	
