.intel_syntax noprefix

.text

.global max

##
## Funkcija:
##
## int max(int a, int b)
##
## vraca vecu od vrednosti a i b. Argumenti funkcije:
##
## -- int a -- [ebp + 8]
## -- int b -- [ebp + 12]
##
max:
	## Prolog funkcije
	enter 0,0

	## NAPOMENA: Na Intel-ovoj arhitekturi postoji specijalni registar
	## EFLAGS (32-bitni) ciji se bitovi tumace zasebno kao tzv. flag-ovi. 
	## Svaki od flag-ova predstavlja neku vrstu indikatora koji govori
	## o rezultatu poslednje izvrsene operacije. Svaka instrukcija azurira
	## ove flagove na osnovu svog rezultata. Najvazniji flag-ovi za nas
	## su carry flag (CF), zero flag (ZF), sign flag (SF) i overflow (OF).
	## CF se postavlja na 1 svaki put kada prilikom neke operacije nad
	## neoznacenim brojevima dodje do prenosa na poslednjoj poziciji.
	## ZF se postavlja na 1 svaki put kada je rezultat
	## neke operacije 0. SF se postavlja na 1 svaki put kada je rezultat
	## operacije negativan (tumacen kao oznaceni broj u potpunom
	## komplementu, tj. u SF se uvek kopira bit najvece tezine rezultata).
	## OF se postavlja na 1 svaki put kada se prilikom operacije nad
	## oznacenim brojevima pojavi prekoracenje (npr. sabiramo dva
	## pozitivna cela broja, a rezultat ispadne negativan).

	## NAPOMENA: Instrukcija cmp vrsi uporedjivanje svoja dva operanda.
	## Uporedjivanje se vrsi oduzimanjem, tj. instrukcija cmp oduzima
	## drugi operand od prvog, ali za razliku od sub instrukcije ne
	## upisuje rezultat oduzimanja nigde, vec samo azurira flag-ove na
	## osnovu vrednosti rezultata. Ovi flag-ovi se naknadno mogu koristiti
	## za uslovne skokove.

	## Premestamo a u eax, a b u ecx, a zatim ih uporedjujemo.
	mov eax, [ebp + 8]
	mov ecx, [ebp + 12]
	cmp eax, ecx

	## NAPOMENA: Postoje dve vrste skokova: uslovni i bezuslovni.
	## Instrukcija bezuslovnog skoka je instrukcija jmp. Ona uvek
	## skace na adresu koja joj je data kao operand. Instrukcija
	## uslovnog skoka ima vise, i one skacu samo ako je odredjeni
	## uslov ispunjen, u suprotnom se nastavlja sa instrukcijom koja
	## sledi iza instrukcije skoka. Na primer, instrukcija jz (jump zero)
	## skace ako je rezultat prethodne instrukcije bio 0. Instrukcija
	## jc skace ako je pri prethodnoj instrukciji bilo prenosa, itd.
	## Da li je uslov ispunjen gleda se na osnovu flag-ova u EFLAGS
	## registru. Tako na primer, ako je ZF postavljen, to onda znaci
	## da je rezultat poslednje instrukcije bio 0. Dakle, jz instrukcija
	## skace samo ako je ZF postavljen. Slican je odnos jc instrukcije
	## i CF flag-a. Vazno je napomenuti da se instrukcije skoka obicno
	## koriste posle instrukcije cmp koja vrsi uporedjivanje oduzimanjem.
	## Tako, ako zelimo da testiramo da li su dve vrednosti jednake, tada
	## je jasno da je to ispunjeno kada je njihova razlika jednaka nuli,
	## pa se u tom slucaju nakon cmp instrukcije koristi jz instrukcija.
	## Iz ovog razloga, za jz instrukciju postoji i alternativni mnemonik
	## je (jump equal). Slicno, ako zelimo da nam je prvi operand
	## instrukcije cmp veci od drugog, to je ekvivalentno sa tim da je
	## njihova razlika pozitivna (ako se gledaju kao oznaceni brojevi),
	## odnosno da nije bilo pozajmice na poslednjoj poziciji i nije
	## nula (ako se gledaju kao neoznaceni brojevi). U prvom slucaju
	## koristi se instrukcija jg (jump greater) koja u stvari testira
	## OF,SF i ZF bit (OF i SF treba da su jednaki, a ZF treba da je
	## iskljucen), a u drugom instrukcija
	## ja (jump above) koja testira bitove CF i ZF (oba treba da su
	## iskljucena). Slicne instrukcije postoje i za sve druge relacije
	## koje testiraju odgovarajuce kombinacije flag-ova. U nasem primeru
	## koristi se instrukcija jge (jump greater or equal) koja skace
	## ako je prvi operand cmp instrukcije bio veci ili jednak od drugog
	## (tj. ako je njihova razlika veca ili jednaka nuli). 
	
	## Ako je a vece, tada preskacemo sledecu instrukciju i u eax registru
	## ostaje vrednost a.
	jge a_vece

	## U suprotnom prebacujemo b u eax.
	mov eax, ecx
	
a_vece:

	## U registru eax se sada nalazi veca od dve vrednosti.

	## Epilog funkcije
	leave
	ret
	
