.intel_syntax noprefix


.data

two: .double 2.0
	
.text

.global mobius

#############################################################################
##
## Funkcija odredjuje koordinate tacke (x,y,z) na Mobiusovoj traci, koja je
## zadata sledecim parametarskim jednacinama:
##
## x(u,v) = (1 + (v/2)*cos(u/2)) * cos(u)
## y(u,v) = (1 + (v/2)*cos(u/2)) * sin(u)
## z(u,v) = (v/2)*sin(u/2)
##
## za 0 <= u < 2*pi i -1 <= v <= 1.
##
## void mobius(double u, double v, double * x, double *y, double *z);
##
## -- double u --  [ebp+8]  -- parametar u
## -- double v --  [ebp+16] -- parametar v
## -- double *x -- [ebp+24] -- adresa na koju se smesta x
## -- double *y -- [ebp+28] -- adresa na koju se smesta y
## -- double *z -- [ebp+32] -- adresa na koju se smesta z
##
#############################################################################
mobius:
	## Prolog funkcije
	enter 0,0
	push edi

	## Izracunavamo koordinate x, y, z
	
	fld qword ptr [ebp+8]        ## stek: u
	fld st                       ## stek: u,u
	fsincos	                     ## stek: u,sin(u),cos(u)
	fxch st(2)                   ## stek: cos(u),sin(u),u
	fdiv qword ptr two           ## stek: cos(u),sin(u),u/2
	fsincos                      ## stek: cos(u),sin(u),sin(u/2),cos(u/2)	
	fld qword ptr [ebp+16]       ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v
	fdiv qword ptr two           ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2
	fld st                       ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2
	                             ##       v/2
	fmul st(0), st(2)	     ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2
				     ##       v/2 * cos(u/2)
	fld1                         ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2
	                             ##       v/2 * cos(u/2), 1
	faddp                        ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2
	                             ##       1 + v/2 * cos(u/2) = K
	fld st                       ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2
	                             ##       K,K
	fmul st(0), st(6)            ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2
	                             ##       K,K*cos(u)=x

	## Smestamo x na za to predvidjenu lokaciju
	mov edi, [ebp+24]
	fstp qword ptr [edi]         ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2
	                             ##       K
	fmul st(0), st(4)            ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2
	                             ##       K*sin(u)=y

	## Smestamo y na za to predvidjenu lokaciju
	mov edi, [ebp+28]
	fstp qword ptr [edi]         ## stek: cos(u),sin(u),sin(u/2),cos(u/2),v/2

	fmul st(0), st(2)            ## stek: cos(u),sin(u),sin(u/2),cos(u/2),
	                             ##       v/2 * sin(u/2) = z

	## Smestamo z na za to predvidjenu lokaciju
	mov edi, [ebp+32]
	fstp qword ptr [edi]         ## stek: cos(u),sin(u),sin(u/2),cos(u/2)


	## Skidamo sa steka preostale vrednosti
	fcompp                       ## stek: cos(u),sin(u)
	fcompp                       ## stek: 

	## Epilog funkcije
	pop edi
	leave
	ret
	