.intel_syntax noprefix


.text
.global longest

###########################################################################
##
## Funkcija pronalazi najduzi uzastopni rastuci podniz u nizu brojeva.
## Funkcija upisuje indeks pocetka podniza u lokaciju s, a duzinu podniza
## u lokaciju l.
##	
## void longest(int *a, int n, int *s, int *l);
##
## -- int * a -- [ebp+8] -- adresa pocetka niza
## -- int n --  [ebp+12] -- duzina niza
## -- int * s --[ebp+16] -- adresa na koju se upisuje pocetni indeks
## -- int * l --[ebp+20] -- adresa na koju se upisuje duzina sekvence
##########################################################################

longest:
	## Prolog funkcije
	enter 8,0
	push edi
	push esi
	push ebx

	## Upisujemo u ecx duzinu niza. ecx cemo koristiti kao indeks u
	## petlji.
	mov ecx, [ebp+12]

	## Na lokaciji [ebp-4] cemo cuvati indeks pocetka do sada najduzeg
	## podniza. Na lokaciji [ebp-8] cemo cuvati duzinu do sada najduzeg
	## podniza.
	mov dword ptr [ebp-4], -1
	mov dword ptr [ebp-8], 0

	## Ako u nizu nema elemenata, prelazimo odmah na kraj.
	jecxz finish

	## Registar esi ce nam cuvati adresu tekuceg elementa niza.
	mov esi, [ebp+8]

	## Postavljamo smer kretanja u nizu.
	cld
	
	## Registar ebx ce nam cuvati indeks pocetka tekuceg rastuceg podniza.
	## Registar edx ce nam cuvati duzinu tekuceg podniza. Registar edi ce
	## cuvati prethodni element niza (sa kojim poredimo tekuci).
	## Inicijalizujemo pocetak prve sekvence: ona pocinje pocetnim
	## elementom niza, pa je indeks njenog pocetka 0, duzina je inicijalno
	## 1, a za prethodni element postavljamo upravo procitani pocetni
	## element niza.
	xor ebx, ebx
	mov edx, 1
	lodsd
	mov edi, eax

	## S obzirom da smo vec procitali jedan element, umanjujemo
	## brojac. Ako je to i jedini element u nizu prelazimo na
	## zavrsavanje tekuce sekvence.
	dec ecx
	jecxz finish_sequence

	## U petlji citamo element po element i uporedjujemo ga sa prethodnim.
next_number:
	lodsd
	cmp eax, edi

	## Ako nije veci od prethodnog, to je kraj tekuce sekvence. 
	jle finish_sequence

	## Uvecavamo duzinu tekuce sekvence.
	inc edx

prepare_next_element:
	## Pamtimo tekuci u edi registru, i prelazimo na sledeci element.
	mov edi, eax
	loop next_number

finish_sequence:
	## Kada se sekvenca zavrsi, bilo zato sto je naisao manji ili jednak
	## element, bilo zato sto je niz zavrsen, uporedjujemo duzinu upravo
	## zavrsene sekvence sa do sada najduzom, i ako je duza tada pamtimo
	## njen pocetak i duzinu u za to predvidjenim lokacijama. 
	cmp edx, [ebp-8]
	jg new_longest
	jmp prepare_next_sequence
	
new_longest:
	mov [ebp-8], edx
	mov [ebp-4], ebx

	## Ako se sekvenca nije zavrsila zato sto se naislo na kraj niza, tada
	## je potrebno inicijalizovati sledecu sekvencu (koja je zapoceta
	## poslednjim ucitanim elementom).
prepare_next_sequence:
	jecxz finish
	add ebx, edx
	mov edx, 1
	jmp prepare_next_element
	

	## Upisujemo vrednosti u za to predvidjene lokacije.
finish:	
	mov eax, [ebp-4]
	mov edi, [ebp+16]
	mov [edi], eax
	mov eax, [ebp-8]
	mov edi, [ebp+20]
	mov [edi], eax


done:	
	## Epilog funkcije
	pop ebx
	pop esi
	pop edi
	leave
	ret
	