/* Funkcija pretrazuje niz celih brojeva duzine n, 
   trazeci u njemu element x. Ako se element pronadje
   funkcija vraca indeks pozicije na kojoj je pronadjen.
   Ako element nije pronadjen u nizu, funkcija vraca 
   -1, kao indikator neuspesne pretrage. */
int linearna_pretraga(int a[], int n, int x)
{
  int i;

  for(i = 0; i < n; i++)
    if(a[i] == x)
      return i;

  return -1;
}

/* Funkcija trazi u sortiranom nizu a[] duzine n
   broj x. Vraca indeks pozicije nadjenog elementa
   ili -1, ako element nije pronadjen */
int binarna_pretraga (int a[], int n, int x)
{
  int l = 0;
  int d = n - 1;

  /* Dokle god je indeks l levo od indeksa... d */
  while (l <= d)
    {
      /* Racunamo sredisnji indeks */
      int s = (l + d) / 2;
      
      /* Ako je sredisnji element veci od x,
	 tada se x mora nalaziti u levoj polovini niza */
      if (x < a[s])
        d = s - 1;
      /* Ako je sredisnji element manji od x,
	 tada se x mora nalaziti u desnoj polovini niza */
      else if (x > a[s])
        l = s + 1;
      else
	/* Ako je sredisnji element jednak x, 
	   tada smo pronasli x na poziciji s */
        return s; 
      
    }
  
  /* ako nije pronadjen vracamo -1 */
  return -1;  
}
