USE DVDClub;

WITH LeasePerDay (EmployeeID, LeaseDate, LeaseCount)
AS
(
SELECT EM.ID, LD.LeaseDate, (SELECT COUNT(*) FROM Lease WHERE Lease.LeaseDate = LD.LeaseDate
                                                        AND Lease.EmployeeID = EM.ID) AS LeaseCount
FROM (SELECT Employee.ID FROM Employee) AS EM, (SELECT Lease.LeaseDate FROM Lease) AS LD
),
AvgLeasePerDay (EmployeeID, AvgLease)
AS
(
SELECT LeasePerDay.EmployeeID, AVG(LeasePerDay.LeaseCount + 0.0) AS AvgLease
FROM LeasePerDay
GROUP BY EmployeeID
)
SELECT Employee.*, AvgLeasePerDay.AvgLease
FROM Employee JOIN AvgLeasePerDay ON Employee.ID = AvgLeasePerDay.EmployeeID
ORDER BY AvgLeasePerDay.AvgLease;

