USE DVDClub;
GO


WITH LeasePerMovie (MovieID, LeaseCount)
AS
(
SELECT Movie.ID, 
       SUM(CASE WHEN Lease.ID IS NULL THEN 0 ELSE 1 END) AS LeaseCount 
FROM Movie LEFT OUTER JOIN Lease ON Movie.ID = Lease.MovieID
GROUP BY Movie.ID
)
SELECT Movie.*, LeaseCount 
FROM Movie JOIN LeasePerMovie ON Movie.ID = LeasePerMovie.MovieID
ORDER BY LeaseCount DESC;

