USE DVDClub;
GO

SELECT * FROM Movie 
WHERE (SELECT COUNT(*) 
       FROM MovieGenre 
       WHERE MovieGenre.MovieID = Movie.ID) > 1;

       
WITH GenresPerMovie (MovieID, GenreCount)
AS
(SELECT MovieGenre.MovieID, COUNT(*) AS GenreCount
 FROM MovieGenre
 GROUP BY MovieGenre.MovieID)
SELECT Movie.*, GenresPerMovie.GenreCount
FROM Movie JOIN GenresPerMovie ON Movie.ID = GenresPerMovie.MovieID
WHERE GenresPerMovie.GenreCount > 1
ORDER BY GenreCount DESC;
