/* Program tabelarno ispisuje vrednosti raznih matematickih funkcija u tackama
   datog intervala sa datim korakom. */ 

#include <stdio.h>
#include <math.h>

/* NAPOMENA:
   Zaglavlje math.h sadrzi deklaracije razih matematickih funkcija. Izmedju
   ostalog, to su sledece funkcije:
   double sin(double x);
   double cos(double x);
   double tan(double x);
   double asin(double x);
   double acos(double x);
   double atan(double x);
   double atan2(double y, double x);
   double sinh(double x);
   double cosh(double x);
   double tanh(double x);
   double exp(double x);
   double log(double x);
   double log10(double x);
   double pow(double x, double y);
   double sqrt(double x);
   double ceil(double x);
   double floor(double x);
   double fabs(double x);
*/

/* NAPOMENA:
   Binarne instrukcije koje cine funkciju su takodje negde u memoriji, i imaju
   svoju adresu. Samim tim, moguce je definisati pokazivac na
   funkciju. Deklaracija: 
   
   int (*fp)(int);
   
   definise promenljivu f, koja je tipa "pokazivac na funkciju koja prihvata
   int, i vraca int". Ova promenljiva sadrzi adresu neke funkcije tog tipa.
   Ako je deklarisana funkcija:
   
   int f(int a);
   
   Tada je moguce dodeliti:
   
   fp = &f;
   
   Sada fp sadrzi adresu funkcije f. Funkcija f se sada moze pozivati sa:
   
   (*fp)(3);
   
   Zagrade oko izraza *fp su neophodne zbog prioriteta
   operatora. Dereferenciranjem pokazivaca na funkciju dobija se funkcija,
   koja se onda poziva na uobicajen nacin.
   
   Ovo ima najvise smisla kada unutar neke funkcije zelimo da koristimo neku
   drugu funkciju, koja nije uvek ista, i bira se prilikom poziva. Tada se kao
   argument funkcije predaje pokazivac na funkciju odgovarajuceg tipa. Putem
   tog pokazivaca se iznutra poziva odgovarajuca funkcija.
 */


/* Funkcija tabeliraj() prihvata granice intervala a i b, korak h, kao i
   pokazivac f koji pokazuje na funkciju koja prihvata double argument, i
   vraca double rezultat. Za tako datu funkciju ispisuje njene vrednosti u
   intervalu [a,b] sa korakom h */

void tabeliraj(double a, double b, double h, double (*f)(double))
{
  double x;
  
  printf("-----------------------\n");
  for(x = a; x <= b; x+=h)
    printf("| %8.3f | %8.3f |\n", x, (*f)(x));
  printf("-----------------------\n");

}


/* Funkcija main */
int main()
{
  double a, b, h;
  
  /* Unosimo granice intervala */
  printf("Uneti granice intervala: ");
  scanf("%lf%lf", &a, &b);
  
  /* Unosimo korak */
  printf("Uneti korak: ");
  scanf("%lf", &h);
  
  /* Testiramo funkciju tabeliraj() za sin(), cos() i exp() */
  printf("sin(x)\n");
  tabeliraj(a, b, h, &sin);
  printf("cos(x)\n");
  tabeliraj(a, b, h, &cos);
  printf("exp(x)\n");
  tabeliraj(a, b, h, &exp);
  
  return 0;
}
