/* Program ucitava linije iz fajla ulaz.txt i zatim ih ispisuje na standardnom
   izlazu sortirane po duzini, pocev od najkrace linije */


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>


#define MAX_RED 1024
#define MAX_REDOVA 1024


/* NAPOMENA: Pokazivacke promenljive su podaci kao i svi drugi, pa
   samim tim imaju svoju adresu u memoriji. Zbog toga je moguce 
   govoriti o pokazivacima na pokazivace. Npr, ako je definisan
   pokazivac na int:

   int *p;

   tada mozemo definisati pokazivac na pokazivac na int:
   
   int **pp;

   Ovaj pokazivac moze uzeti adresu pokazivacke promenljive p:

   pp = &p;

   Nakon toga se pokazivackoj promenljivoj p moze pristupiti i
   indirektno, preko pokazivaca na pokazivac pp:

   *pp

   Takodje, celom broju na koji pokazuje p moze se pristupiti 
   na sledeci nacin:

   **pp

   zato sto je **pp ekvivalentno sa *p.

 */

/* NAPOMENA: Elementi nizova mogu biti bilo kog tipa, pa i 
   pokazivaci. Npr, niz pokazivaca na karaktere se moze definisati
   na sledeci nacin:

   char * pokazivaci[100];

   Ovim se rezervise prostor za niz od 100 pokazivaca na 
   karaktere. Njima se pristupa putem indeksa, kako je i 
   uobicajeno. S obzirom da se ime niza uvek ponasa kao adresa
   prvog objekta u nizu, sledi da je izraz:

   pokazivaci

   tipa "pokazivac na pokazivac na char". Otuda se uobicajena 
   pokazivacka aritmetika moze primenjivati i na nizove pokazivaca.
*/

/* Funkcija sortira niz pokazivaca na karaktere, pri cemu
   je kriterijum sortiranja duzina stringova na koje pokazuju
   ti pokazivaci. */
void sortiraj(char *redovi[], int n);

int main()
{
  char redovi[MAX_REDOVA][MAX_RED];
  char *p_redovi[MAX_REDOVA];

  int i, n;
  FILE * in;
 
  /* Otvaramo fajl */
  in = fopen("ulaz.txt", "r");

  /* Proveravamo da li smo uspesno otvorili fajl */
  if(in == NULL)
    {
      printf("Greska! Fajl nije uspesno otvoren!\n");
      exit(1);
    }
  
  /* Citamo linije, i smestamo ih u dvodimenzioni niz karaktera redovi[] (i-tu
     liniju smestamo u niz redovi[i]). Citamo najvise MAX_REDOVA. Pokazivac
     p_redovi[i] postavljamo da pokazuje na prvi karakter u nizu redovi[i]. */ 
  for(i = 0; i < MAX_REDOVA; i++)
    if(fgets(redovi[i], MAX_RED, in) != NULL)
      p_redovi[i] = redovi[i];
    else
      break;
  
  n = i;

  /* Zatavaramo fajl */
  fclose(in);
  
  /* NAPOMENA: Umesto da sortiramo niz nizova, sto podrazumeva zamenu
     vrednosti citavih nizova, efikasnije je da definisemo niz pokazivaca
     na karaktere koje cemo da usmerimo najpre na odgovarajuce stringove 
     koji se nalaze u nizu nizova redovi[] (Pokazivac p_redovi[i] se 
     se usmerava na string u nizu redovi[i]). Nakon toga se sortira niz
     pokazivaca, tj. pokazivaci se ispremestaju tako da redom pokazuju 
     na stringove po rastucim duzinama. Ovim je sortiranje bitno efikasnije
     jer je brze razmeniti dva pokazivaca nego citave nizove. */

  /* Sortiramo niz pokazivaca */
  sortiraj(p_redovi, n);
  
  
  /* Prikazujemo linije u poretku rasta duzina */
  for(i = 0; i < n;  i++)
    fputs(p_redovi[i], stdout);
  
  return 0;
}


/* Funkcija razmenjuje vrednosti dva pokazivaca na karaktere.
   S obzirom da je potrebno preneti adrese ovih promenljivih, 
   parametri su tipa "pokazivac na pokazivac na char". */
void razmeni(char **s, char **t)
{
  char *p;

  p = *s;
  *s = *t;
  *t = p;

}

/* Funkcija implementira uobicajeni algoritam sortiranja izborom
   najmanjeg elementa, pri cemu se pod najmanjim elementom ovde
   podrazumeva pokazivac koji pokazuje na string koji je najkraci */
void sortiraj(char *redovi[], int n)
{
  
  int i,j, min;

  for(i = 0; i < n - 1; i++)
    {
      min = i;
      for(j = i + 1; j < n; j++)
	if(strlen(redovi[j]) < strlen(redovi[min]))
	  min = j;
      
      if(min != i)
	{
	  razmeni(&redovi[min], &redovi[i]);
	}
    }

}
