#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/* Deklaracija funkcije standard_deviation(). */
void standard_deviation(int n, double *x, double *sigma);

int main()
{
        int  n;	       /* Duzina datog vektora. */
	double  *x;    /* Vektor vrednosti za koji se racuna
		        * standardna devijacija. */
	double sigma;  /* Izracunata vrednost standardne
		        * devijacije. */
	int i;	       /* Brojac u petljama. */

	/* Ucitava se duzina datog vektora. */
	scanf("%d\n", &n);
	assert(n > 1);

	/* Alocira se memorija za elemente datog vektora i ucitavaju se
	 * isti. */
	x = malloc(n * sizeof(double));
	assert(x != NULL);
	for (i = 0; i < n; i++)
		scanf("%lf", &x[i]);

	/* Izracunava se i stampa vrednost standardne devijacije. */
	standard_deviation(n, x, &sigma);
	printf("%g\n", sigma);

	/* Oslobadja se memorija koriscena za elemente datog vektora. */
	free(x);

	return 0;
}
