.intel_syntax noprefix

.text
.global isbn

###########################################################################
##
## Funkcija:
##	void isbn(char *digits);
##
## dopunjava dati string sa ciframa ISBN broja kontrolnom cifrom. Argument
## funkcije je:
##
## -- char * digits -- [ebp+8] -- adresa prvog u nizu karaktera koji
##    predstavljaju cifre ISBN broja
##
## Pretpostavka je da se dati niz sastoji od 9 karaktera, koji su svi cifre,
## kao i da je sam niz duzine 11 karaktera, kako bi funkcija mogla da u
## njega doda kontrolnu cifru i terminirajucu nulu.
##
###########################################################################
isbn:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

        ## Registar esi ce sadrzati adresu tekuce cifre ISBN broja, dok
        ## ce registar ecx sadrzati broj sa kojim se ta cifra mnozi
        ## prilikom formiranja kontrolne sume (istovremeno ce registar
        ## ecx biti koriscen i kao brojac).  Kontrolna suma ce biti
	## akumulirana u registru ebx).
        cld
        mov     esi, [ebp+8]
        mov     ecx, 10
        xor     ebx, ebx

next_digit:
        ## Proverava se da li su procesirane sve cifre; ako je tako,
	## prelazi se na racunanje kontrolne cifre.
        cmp     ecx, 2
        jb calculate

        ## Ucitava se naredna cifra i zaracunava u kontrolnu sumu.
        xor     eax, eax
        lodsb
        sub     eax, '0'
        mul     ecx
        add     ebx, eax

        ## Prelazi se na narednu cifru.
        dec     ecx
        jmp next_digit

calculate:
        ## Odredjuje se ostatak pri deljenju kontrolne sume sa 11.
        mov     eax, ebx
        cdq
        mov     ecx, 11
        div     ecx

        ## Ukoliko je gornji ostatak jednak 0, onda je i kontrolna cifra
	## jednaka 0.
        cmp     edx, 0
        jne not_zero
        mov     al, '0'
        je store

not_zero:
        ## Odredjuje se kontrolna cifra kao broj koji treba dodati na
	## kontrolnu sumu da bi ista bila deljiva sa 11.
        mov     al, 11
        sub     al, dl

        ## Proverava se da li je kontrolna cifra 10, i u tom slucaju se
	## koristi 'X' kao odgovarajuci karakter, a u suprotnom se
	## koristi karakter koji direktno predstavlja kontrolnu cifru.
        cmp     al, 10
        jne not_ten
        mov     al, 'X'
        je store
not_ten:
        add     al, '0'

store:
        ## Dodaje se kontrolna cifra, kao i terminirajuca nula u
	## string sa ciframa ISBN broja.
        mov     edi, esi
        stosb
        xor     eax, eax
        stosb
        
        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret
