.intel_syntax noprefix

	
.text
.global stammer

##########################################################################
##
## Funkcija:
##
## void stammer(char * s, char * p);
##
## zamenjuje u stringu svaku sekvencu istih ne-samoglasnika x duzine
## n > 1 sa jedim karakterom x.
## (npr. sekvencu "bbbaa" zamenjuje sa "baa"). Argumenti funkcije su:
##
## -- char * s  -- [ebp+8]  -- adresa ulaznog stringa
## -- char * p  -- [ebp+12] -- adresa niza u koji treba upisati rezultat
##
###########################################################################
stammer:	
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

	## U registar esi smestamo adresu stringa, a u registar edi adresu
	## odredisnog stringa.
	mov esi, [ebp + 8]
	mov edi, [ebp + 12]
	
	## Postavljamo smer kretanja kroz string
	cld

	## Ucitavamo prvi string u al registar
	lodsb

	## Ako je prazan string, zavrsavamo funkciju.
	cmp al, 0
	je last_char

	## U suprotnom upisujemo karakter u izlazni string.
	stosb
	
	## Registar ah ce cuvati prethodni karakter, a al tekuci.
	mov ah, al
	
next_char:
	## Ucitavamo sledeci karakter
	lodsb

	## Provaravamo da li je terminirajuca nula.
	cmp al, 0
	je last_char
	
	## Provaravamo da li je tekuci karakter samoglasnik, u kom slucaju
	## ga samo prepisujemo na izlaz.
	cmp al, 'a'
	je store
	cmp al, 'e'
	je store
	cmp al, 'i'
	je store
	cmp al, 'o'
	je store
	cmp al, 'u'
	je store
	cmp al, 'A'
	je store
	cmp al, 'E'
	je store
	cmp al, 'I'
	je store
	cmp al, 'O'
	je store
	cmp al, 'U'
	je store

	## Ako nije samoglasnik, onda proveravamo da li je isti kao
	## prethodni karakter.
	cmp al, ah
	je continue

store:
	## Upisujemo karakter u izlazni string.
	stosb
	
continue:
	## Prelazimo na sledeci karakter.
	mov ah, al
	jmp next_char
last_char:
	# Upisujemo terminirajucu nulu
	stosb
	
done:	
	## Epilog funkcije
	pop edi
	pop esi
	pop ebx
	leave
	ret
	